
/**
 * class  TextFileViewer
 * This is the help Console. It takes a file has an argument and displays
 * the contents of that file in the help windows along with the Print and 
 * Close Buttons. It will extend a Panel with two panels it self one for 
 * the TextArea Component and one for the Close and Print Button.
 * This will be heavly modify in the next release of ChemConsole v-0.4
 * so don't use this code unless you really want to.
 * @author Nathan Stevens
 * @version 0.2
 */ 

import java.awt.*;
import java.io.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.text.*;
//import javax.swing.*;
//import javax.swing.border.*;
//import javax.swing.text.*;

public class TextFileViewer extends JPanel implements ActionListener
{
  private ChemToolFrame frame;
  private JTextArea textArea;
  private JTextField tf;
  private File[] files;                    // note: to speed up coding the
  private String text;                     // eliment in the array is one not
  private String title;                    // zero.
  private int cPage;                      // the current page being displayed 
  private int N_Cols;
  private int N_Rows;
  private int val;

  // Constructor
  public TextFileViewer(File[] files)
    {
      this(files, "Text File Viewer", 20, 80);
    }
  public TextFileViewer(File[] files, String title, int row, int col)
    { 
      // create the file object and file extentions
      this.files  = files;
      setLayout(new BorderLayout());
      setLocation(50, 70);

      // Construct the TextArea and add it to frame
      N_Rows = row;
      N_Cols = col;
      
      textArea = new JTextArea("" ,N_Rows, N_Cols);	
      textArea.setEditable(false);
      textArea.setLineWrap(true);
      textArea.setWrapStyleWord(true);

      // add the textarea to scroll pane
      JScrollPane areaScrollPane = new JScrollPane(textArea);

      // add border to scroll pane
      Border border;
      border = new BevelBorder(BevelBorder.LOWERED);
      areaScrollPane.setBorder(border);

      add(areaScrollPane, "Center");
      
      // Construct the navigation bar at bottom of page
      JPanel nav = new JPanel();
      FlowLayout ly = new FlowLayout(FlowLayout.CENTER, 2, 5);
      nav.setLayout(ly);

      // Create the components and add it to panel
      JButton bt;
      JLabel lb;
   
      bt = new JButton("  <  ");
      bt.addActionListener(this);
      bt.setActionCommand("down");
      nav.add(bt);
      
      bt = new JButton("  >  ");
      bt.addActionListener(this);
      bt.setActionCommand("up");
      nav.add(bt);
                 
      lb = new JLabel(" Go to: ");
      nav.add(lb);
     
      tf = new JTextField(4);
      tf.addActionListener(this);
      nav.add(tf);
     
      lb = new JLabel(" of " + (files.length - 1) + " ");
      nav.add(lb); 

      bt = new JButton("Print ");
      bt.addActionListener(this);
      bt.setActionCommand("print");
      nav.add(bt);
     
      bt = new JButton("Close ");
      bt.addActionListener(this);
      bt.setActionCommand("close");
      nav.add(bt);      
     
      add(nav, "South");
      
      // add this to the frame class now
      frame = new ChemToolFrame(title, this);

      // call the method list the files with the specific extension
      // and put them into the File[] array
      getPage(1); 

    }
    
  // Method to get the text from the file array at the lacation specifed
  // by the variable nad display it to the text array
  private void getPage(int pageNum)
    { 
      cPage = pageNum;          // set the current page we are now viewing
      text = "";                // The initial text
      
      // print the number in the text field
      tf.setText(String.valueOf(cPage));

      // read int file

      TextInputFile f = new TextInputFile(files[pageNum]);
      while(!f.eof())
        {
          text += f.readLine() + "\n";
        }
      f.close();
      textArea.setText(text); 	  
    } 
  
  // method to read an integer from textfield and go the the page if it
  // exist. It also clear the number when the number after reading it in. 
  private void ReadField()
    {
      //first we check to see the value entered is a valid number
      String s = tf.getText();
      try
	{
          val = Integer.parseInt(s);
	}
      catch(NumberFormatException e)
	{
          System.out.println("Number format exception thrown");
          System.out.println(e);

          tf.setText(String.valueOf(cPage));
	}
       
      if(val > 0 & val < files.length)
	{
          getPage(val);
	}
      else
	{
	  tf.setText(String.valueOf(cPage));
	}  
    }
      
  // Handle the events
  public void actionPerformed(ActionEvent e)
    {
      String cmd;
      cmd = e.getActionCommand();
      
      if(cmd.equals("down") && cPage > 1)
	{
          getPage(cPage - 1);
	}
      else if(cmd.equals("up") && cPage < files.length -1 )
	{
          getPage(cPage + 1);
	}
      else if(cmd.equals("print"))
	{
          // add code
	}
      else if(cmd.equals("close"))
	{
         frame.Close();
	}
      // Ok event is none of the above so it most the textfield event  
      else
	{
          ReadField();
	}
    }

}
       
      


