/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;

public class BabelServer
extends CCServerImpl {
    private static String wdir = "Bwork";
    private String status = "Connected to the Babel Server...";
    private final File conf = new File("Config/babel.cfg");
    private String Babel_Bin = "babel";
    private boolean Active = true;
    private boolean Retrieve = true;
    private int id;

    public BabelServer() {
        this(500);
    }

    public BabelServer(int n) {
        this.id = n;
        if (this.conf.isFile()) {
            TextInputFile textInputFile = new TextInputFile(this.conf);
            this.Active = textInputFile.readBoolean();
            this.Babel_Bin = textInputFile.readString();
            textInputFile.close();
            return;
        }
        System.out.println("Unable to read the Babel Server Config file");
        this.setNull(n);
    }

    public String getRemoteMessage() {
        return this.status;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setRetrieve(boolean bl) {
        this.Retrieve = bl;
    }

    public String getAppBin() {
        return this.Babel_Bin;
    }

    public String getWorkDir() {
        return wdir;
    }

    public boolean runApp(String[] stringArray) {
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            process.waitFor();
            return true;
        }
        catch (Exception exception) {
            System.out.println("An exception occur : " + exception);
            this.setNull(this.id);
            return false;
        }
    }
}

