/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.DateFormat;
import java.util.Date;

public class CCServerManager
extends UnicastRemoteObject
implements CCServer {
    private int MAX_GAUSS;
    private int MAX_MOPAC;
    private int MAX_BABEL;
    private int MAXTHREADS;
    private int MAXUTHREADS;
    private static boolean LOG_FILE;
    private int bc;
    private int mc;
    private int gc;
    private int uc;
    private CCServerImpl[] threads;
    private int id;
    private int uid;
    private int cid;
    private static String mdir;
    private File mdf;
    private static File conf;
    private static File logfile;
    private static TextOutputFile lf;
    private static boolean verbose;
    private String[] blah = new String[]{"blah", "blah"};

    public CCServerManager() throws RemoteException {
        if (conf.isFile()) {
            TextInputFile textInputFile = new TextInputFile(conf);
            this.MAX_BABEL = textInputFile.readInt();
            this.MAX_MOPAC = textInputFile.readInt();
            this.MAX_GAUSS = textInputFile.readInt();
            LOG_FILE = textInputFile.readBoolean();
            textInputFile.close();
            this.MAXTHREADS = this.MAX_GAUSS + this.MAX_MOPAC + this.MAX_BABEL;
            this.MAXUTHREADS = this.MAXTHREADS * 2;
        } else {
            System.out.println("Unable to read Config file " + conf + "\nProgram Terminated.");
            System.exit(1);
        }
        this.threads = new CCServerImpl[this.MAXUTHREADS + 1];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int startAppServer(String string) throws RemoteException {
        CCServerImpl[] cCServerImplArray = this.threads;
        synchronized (cCServerImplArray) {
            if (string.equals("babel")) {
                this.id = 0;
                while (this.id < this.MAX_BABEL) {
                    if (this.threads[this.id] == null) break;
                    ++this.id;
                }
                if (this.id >= this.MAX_BABEL) {
                    return -1;
                }
                this.threads[this.id] = new BabelServer(this.id);
                this.threads[this.id].setDaemon(true);
                this.threads[this.id].start();
                this.threads[this.id].setSM(this);
            } else if (string.equals("mopac")) {
                this.id = this.MAX_BABEL;
                while (this.id < this.MAX_BABEL + this.MAX_MOPAC) {
                    if (this.threads[this.id] == null) {
                        this.mdf = new File(String.valueOf(mdir) + this.id);
                        if (this.mdf.isDirectory()) break;
                        this.mdf.mkdir();
                        break;
                    }
                    ++this.id;
                }
                if (this.id >= this.MAX_BABEL + this.MAX_MOPAC) {
                    return -1;
                }
                this.threads[this.id] = new MopacServer(this.id, String.valueOf(this.mdf.toString()) + "/");
                this.threads[this.id].setDaemon(true);
                this.threads[this.id].start();
                this.threads[this.id].setSM(this);
            } else if (string.equals("gaussain")) {
                this.id = this.MAX_BABEL + this.MAX_MOPAC;
                while (this.id < this.MAXTHREADS) {
                    if (this.threads[this.id] == null) break;
                    ++this.id;
                }
                if (this.id >= this.MAXTHREADS) {
                    return -1;
                }
                this.threads[this.id] = new GaussianServer(this.id);
                this.threads[this.id].setDaemon(true);
                this.threads[this.id].start();
                this.threads[this.id].setSM(this);
            }
        }
        if (verbose) {
            this.printStats();
        }
        if (!LOG_FILE) return this.id;
        this.printLogFile();
        return this.id;
    }

    public int startUtilityServer() throws RemoteException {
        CCServerImpl[] cCServerImplArray = this.threads;
        synchronized (cCServerImplArray) {
            this.uid = this.MAXTHREADS;
            while (this.uid < this.MAXUTHREADS) {
                if (this.threads[this.uid] == null) break;
                ++this.uid;
            }
            if (this.uid >= this.MAXUTHREADS) {
                int n = -1;
                Object var3_3 = null;
                return n;
            }
            this.threads[this.uid] = new UtilityServer(this.uid);
        }
        this.threads[this.uid].setDaemon(true);
        this.threads[this.uid].start();
        this.threads[this.uid].setSM(this);
        if (verbose) {
            this.printStats();
        }
        if (LOG_FILE) {
            this.printLogFile();
        }
        return this.uid;
    }

    public int startConfigServer() throws RemoteException {
        CCServerImpl[] cCServerImplArray = this.threads;
        synchronized (cCServerImplArray) {
            int n = this.MAXUTHREADS;
            while (n < this.threads.length) {
                if (this.threads[n] == null) break;
                ++n;
            }
            if (this.cid >= this.threads.length) {
                int n2 = -1;
                Object var3_5 = null;
                return n2;
            }
            this.threads[this.cid] = new ConfigServer(this.cid);
            int n3 = this.cid;
            Object var3_6 = null;
            return n3;
        }
    }

    public String getRemoteMessage(int n) throws RemoteException {
        return this.threads[n].getRemoteMessage();
    }

    public String[] getStatus(int n) throws RemoteException {
        return this.threads[n].getStatus();
    }

    public byte[] getFile(int n, String string) throws RemoteException {
        String string2 = String.valueOf(this.threads[n].getWorkDir()) + "/";
        return this.threads[n].getFile(String.valueOf(string2) + string);
    }

    public boolean putFile(int n, byte[] byArray, String string) throws RemoteException {
        String string2 = String.valueOf(this.threads[n].getWorkDir()) + "/";
        return this.threads[n].putFile(byArray, String.valueOf(string2) + string);
    }

    public boolean delFile(int n, String string) throws RemoteException {
        String string2 = String.valueOf(this.threads[n].getWorkDir()) + "/";
        return this.threads[n].delFile(String.valueOf(string2) + string);
    }

    public void Stop(int n) throws RemoteException {
        this.threads[n].stop();
        this.threads[n] = null;
    }

    public void StopJob(int n) throws RemoteException {
        this.threads[n].StopJob();
    }

    public boolean isActive(int n) throws RemoteException {
        return this.threads[n].isActive();
    }

    public boolean runApp(int n, String[] stringArray) throws RemoteException {
        return this.threads[n].runApp(stringArray);
    }

    public String getAppBin(int n) throws RemoteException {
        return this.threads[n].getAppBin();
    }

    public synchronized String[] getStats() {
        String string = null;
        String string2 = null;
        String string3 = null;
        this.bc = 0;
        this.mc = 0;
        this.gc = 0;
        this.uc = 0;
        boolean bl = true;
        int n = 0;
        while (n < this.MAX_BABEL) {
            if (this.threads[n] != null) {
                ++this.bc;
            } else if (bl) {
                this.threads[n] = new BabelServer();
                this.threads[n].start();
                string = this.threads[n].isActive() ? "YES" : "NO";
                this.stopThread(n);
                bl = false;
            }
            ++n;
        }
        bl = true;
        int n2 = this.MAX_BABEL;
        while (n2 < this.MAX_BABEL + this.MAX_MOPAC) {
            if (this.threads[n2] != null) {
                ++this.mc;
            } else if (bl) {
                this.threads[n2] = new MopacServer();
                this.threads[n2].start();
                string2 = this.threads[n2].isActive() ? "YES" : "NO";
                this.stopThread(n2);
                bl = false;
            }
            ++n2;
        }
        bl = true;
        int n3 = this.MAX_BABEL + this.MAX_MOPAC;
        while (n3 < this.MAXTHREADS) {
            if (this.threads[n3] != null) {
                ++this.gc;
            } else if (bl) {
                this.threads[n3] = new GaussianServer();
                this.threads[n3].start();
                string3 = this.threads[n3].isActive() ? "YES" : "NO";
                this.stopThread(n3);
                bl = false;
            }
            ++n3;
        }
        int n4 = this.MAXTHREADS;
        while (n4 < this.MAXUTHREADS) {
            if (this.threads[n4] != null) {
                ++this.uc;
            }
            ++n4;
        }
        int n5 = this.bc + this.mc + this.gc;
        int n6 = this.MAXTHREADS;
        int n7 = this.MAXUTHREADS - this.MAXTHREADS;
        String[] stringArray = new String[]{String.valueOf(n6), String.valueOf(n7), String.valueOf(n5), String.valueOf(this.bc) + " / " + this.MAX_BABEL, string, String.valueOf(this.mc) + " / " + this.MAX_MOPAC, string2, String.valueOf(this.gc) + " / " + this.MAX_GAUSS, string3, String.valueOf(this.uc) + " / " + n7};
        return stringArray;
    }

    private void printStats() {
        System.out.println("\nThe Date and time is : " + CCServerManager.getDateTime());
        String[] stringArray = this.getStats();
        System.out.println("\nThe maximum number of Application Server clients allowed  : " + stringArray[0]);
        System.out.println("The maximum number of Utility Server clients allowed : " + stringArray[1]);
        System.out.println("The number Application Server clients currently connected : " + stringArray[2]);
        System.out.println("\nServer\t\t\t# of client(s)\t\t\tActive");
        System.out.println("======\t\t\t==============\t\t\t======");
        System.out.println("\nBabel\t\t\t" + stringArray[3] + "\t\t\t\t" + stringArray[4]);
        System.out.println("Mopac\t\t\t" + stringArray[5] + "\t\t\t\t" + stringArray[6]);
        System.out.println("Gaussian\t\t" + stringArray[7] + "\t\t\t\t" + stringArray[8]);
        System.out.println("Utility\t\t\t" + stringArray[9] + "\t\t\t\tN/A");
    }

    private static String getDateTime() {
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        return dateFormat.format(date);
    }

    private void printLogFile() {
        lf.println("\nThe Date and Time is : " + CCServerManager.getDateTime());
        String[] stringArray = this.getStats();
        lf.println("\nThe maximum number of Application Server clients allowed  : " + stringArray[0]);
        lf.println("The maximum number of Utility Server clients allowed : " + stringArray[1]);
        lf.println("The number Application Server clients currently connected : " + stringArray[2]);
        lf.println("\nServer\t\t\t# of client(s)\t\t\tActive");
        lf.println("======\t\t\t==============\t\t\t======");
        lf.println("\nBabel\t\t\t" + stringArray[3] + "\t\t\t\t" + stringArray[4]);
        lf.println("Mopac\t\t\t" + stringArray[5] + "\t\t\t\t" + stringArray[6]);
        lf.println("Gaussian\t\t" + stringArray[7] + "\t\t\t\t" + stringArray[8]);
        lf.println("Utility\t\t\t" + stringArray[9] + "\t\t\t\tN/A");
    }

    public String getWorkDir(int n) throws RemoteException {
        return this.threads[n].getWorkDir();
    }

    public String[] getFileList(int n, String string, String string2) throws RemoteException {
        String string3 = this.threads[n].getWorkDir();
        return this.threads[n].getFileList(string3, string, string2);
    }

    public void setRetrieve(int n, boolean bl) throws RemoteException {
        this.threads[n].setRetrieve(bl);
    }

    public boolean setFileTypeID(int n, String string, int n2) throws RemoteException {
        return this.threads[n].setFileTypeID(string, n2);
    }

    public String[] getServerStats(int n) throws RemoteException {
        return this.threads[n].getServerStats();
    }

    public int getMaxBabel() {
        return this.MAX_BABEL;
    }

    public int getMaxMopac() {
        return this.MAX_MOPAC;
    }

    public int getMaxGauss() {
        return this.MAX_GAUSS;
    }

    public synchronized boolean isPassWord(String string) throws RemoteException {
        return true;
    }

    public String[] getMainCfg(int n) throws RemoteException {
        return this.blah;
    }

    public String[] getBabelCfg(int n) throws RemoteException {
        return this.blah;
    }

    public String[] getMopacCfg(int n) throws RemoteException {
        return this.blah;
    }

    public String[] getGaussianCfg(int n) throws RemoteException {
        return this.blah;
    }

    public void setMainCfg(int n, String[] stringArray) throws RemoteException {
    }

    public void setBabelCfg(int n, String[] stringArray) throws RemoteException {
    }

    public void setMopacCfg(int n, String[] stringArray) throws RemoteException {
    }

    public void setGaussianCfg(int n, String[] stringArray) throws RemoteException {
    }

    private void stopThread(int n) {
        try {
            this.Stop(n);
            return;
        }
        catch (RemoteException remoteException) {
            System.out.println(remoteException.toString());
            return;
        }
    }

    public static void main(String[] stringArray) {
        verbose = stringArray.length != 0 && stringArray[0].equals("-v");
        System.out.println("Starting ChemConsole Server......");
        System.setSecurityManager(new RMISecurityManager());
        try {
            CCServerManager cCServerManager = new CCServerManager();
            Naming.rebind("ccserver", cCServerManager);
            System.out.println("ChemConsole Server is running.");
            if (LOG_FILE) {
                logfile = new File("CCSlog.txt");
                lf = new TextOutputFile(logfile, true);
                String string = new String("ChemConsole Server Version 0.4 Log File.\nThe Current date and time is : " + CCServerManager.getDateTime() + "\nThis message is printed every time" + " the ChemConsole Server starts. ");
                lf.println(String.valueOf(string) + "\n");
            }
            if (verbose) {
                cCServerManager.printStats();
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("CCServerManager.main: an exception occurred: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    static {
        mdir = "Mwork";
        conf = new File("Config/main.cfg");
    }
}

