/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class TextInputFile {
    private String fileName;
    private BufferedReader f;
    private DataInputStream stdin;
    private boolean closed = false;
    private boolean useStandardIO = false;
    private boolean eofFlag = false;
    private static final int EMPTY = -1;
    private String lineBuffer = "";
    int lineBufferPtr;
    int ungotChar = -1;

    public TextInputFile() {
        this("Standard input");
    }

    public TextInputFile(File file) {
        try {
            FileReader fileReader = new FileReader(file);
            this.f = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errPrint("Unable to open file \"" + this.fileName + "\"");
        }
        this.fileName = file.getName();
    }

    public TextInputFile(String string) {
        if (string.equalsIgnoreCase("standard input") || string.equalsIgnoreCase("keyboard") || string.equalsIgnoreCase("stdin")) {
            this.stdin = new DataInputStream(System.in);
            this.fileName = "Standard input";
            this.useStandardIO = true;
            return;
        }
        try {
            this.f = new BufferedReader(new FileReader(new File(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errPrint("Unable to open file \"" + string + "\"");
        }
        this.fileName = string;
    }

    public void close() {
        if (this.closed) {
            this.errPrint("\"" + this.fileName + "\" is already closed.");
        }
        if (this.useStandardIO) {
            this.useStandardIO = false;
        } else {
            try {
                this.f.close();
            }
            catch (IOException iOException) {
                this.errPrint("Close failed: Unable to close \"" + this.fileName + "\"");
            }
            this.f = null;
        }
        this.closed = true;
        this.lineBuffer = "";
    }

    public boolean eof() {
        try {
            char c = this.readACharacterThrowsEOF();
            this.pushACharacter(c);
        }
        catch (EOFException eOFException) {
            return true;
        }
        return false;
    }

    private void pushACharacter(char c) {
        this.ungotChar = c;
    }

    private char readACharacter() {
        try {
            return this.readACharacterThrowsEOF();
        }
        catch (EOFException eOFException) {
            this.errPrint("Attempt to read past end of file on " + this.fileName);
            return '\u0000';
        }
    }

    private char readACharacterThrowsEOF() throws EOFException {
        if (this.closed) {
            this.errPrint("Read failed: \"" + this.fileName + "\" is already closed.");
        }
        if (this.ungotChar != -1) {
            char c = (char)this.ungotChar;
            this.ungotChar = -1;
            return c;
        }
        if (this.lineBufferPtr < this.lineBuffer.length()) {
            return this.lineBuffer.charAt(this.lineBufferPtr++);
        }
        this.readALineFromFile();
        return this.lineBuffer.charAt(this.lineBufferPtr++);
    }

    private void readALineFromFile() throws EOFException {
        try {
            if (this.useStandardIO) {
                if (this.eofFlag) {
                    throw new EOFException();
                }
                this.lineBuffer = this.stdin.readLine();
                if (this.lineBuffer != null) {
                    if (this.lineBuffer.indexOf(26) != -1) {
                        this.lineBuffer = this.lineBuffer.substring(0, this.lineBuffer.indexOf(26));
                        if (this.lineBuffer.length() == 0) {
                            this.lineBuffer = null;
                        }
                        this.eofFlag = true;
                    } else if (this.lineBuffer.indexOf(4) != -1) {
                        this.lineBuffer = this.lineBuffer.substring(0, this.lineBuffer.indexOf(4));
                        if (this.lineBuffer.length() == 0) {
                            this.lineBuffer = null;
                        }
                        this.eofFlag = true;
                    }
                }
            } else {
                this.lineBuffer = this.f.readLine();
            }
            if (this.lineBuffer == null) {
                throw new EOFException();
            }
            this.lineBuffer = String.valueOf(this.lineBuffer) + "\n";
            this.lineBufferPtr = 0;
            return;
        }
        catch (IOException iOException) {
            if (iOException instanceof EOFException) {
                throw new EOFException();
            }
            this.errPrint("Read on \"" + this.fileName + "\" failed: " + iOException);
            return;
        }
    }

    private String readAToken() {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c = this.readACharacter()) == ' ' || c == '\n' || c == '\t') {
        }
        if (c == '\"') {
            c = this.readACharacter();
            while (c != '\"') {
                stringBuffer.append(c);
                c = this.readACharacter();
                if (c != '\n') continue;
                this.errPrint("No terminating quote for quoted string in \"" + this.fileName + "\"");
            }
            c = this.readACharacter();
        } else {
            do {
                stringBuffer.append(c);
            } while ((c = this.readACharacter()) != ' ' && c != '\n' && c != '\t');
        }
        while (c == ' ' || c == '\t') {
            c = this.readACharacter();
        }
        if (c != '\n') {
            this.pushACharacter(c);
        }
        return new String(stringBuffer);
    }

    public boolean readBoolean() {
        String string = this.readAToken().toLowerCase();
        if (string.equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return false;
        }
        this.errPrint("Unable to convert \"" + string + "\" to a boolean");
        return false;
    }

    public byte readByte() {
        String string = this.readAToken();
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.errPrint("Unable to convert \"" + string + "\" to a byte");
            return 0;
        }
    }

    public char readChar() {
        char c;
        while ((c = this.readACharacter()) == ' ' || c == '\n' || c == '\t') {
        }
        char c2 = c;
        while ((c = this.readACharacter()) == ' ' || c == '\t') {
        }
        if (c != '\n') {
            this.pushACharacter(c);
        }
        return c2;
    }

    public double readDouble() {
        String string = this.readAToken();
        try {
            Double d = Double.valueOf(string);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            this.errPrint("Unable to convert \"" + string + "\" to a double");
            return 0.0;
        }
    }

    public float readFloat() {
        String string = this.readAToken();
        try {
            Float f = Float.valueOf(string);
            return f.floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            this.errPrint("Unable to convert \"" + string + "\" to a float");
            return 0.0f;
        }
    }

    public int readInt() {
        String string = this.readAToken();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.errPrint("Unable to convert \"" + string + "\" to a int");
            return 0;
        }
    }

    public String readLine() {
        StringBuffer stringBuffer = new StringBuffer();
        char c = this.readACharacter();
        while (c != '\n') {
            stringBuffer.append(c);
            c = this.readACharacter();
        }
        return stringBuffer.toString();
    }

    public long readLong() {
        String string = this.readAToken();
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.errPrint("Unable to convert \"" + string + "\" to a long");
            return 0L;
        }
    }

    public short readShort() {
        String string = this.readAToken();
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.errPrint("Unable to convert \"" + string + "\" to a short");
            return 0;
        }
    }

    public String readString() {
        return this.readAToken();
    }

    private void errPrint(String string) {
        System.out.println(string);
    }
}

