
/**
 * BabelServer.java
 * This interfaces to the babel application
 *
 * Created: Tue May 25 16:21:27 1999
 *
 * @author Nathan Stevens
 * @version 0.4 July-99
 */
import java.io.*;

public class BabelServer extends CCServerImpl {

    private static String wdir = "Bwork";     //the babel working directory
    private String status = "Connected to the Babel Server...";
    private final File conf = new File("Config/babel.cfg");
    private String Babel_Bin = "babel";
    private boolean Active = true;
    private boolean Retrieve = true;
    private int id;

    // The default constructor
    public BabelServer() {
	this(500); 
    }

    public BabelServer(int id)
    {
	this.id = id;
        //Read config file
        if(conf.isFile()) { 
	    TextInputFile f = new TextInputFile(conf);
            Active = f.readBoolean();
            Babel_Bin = f.readString();
            f.close();    
	}
        else {
	    System.out.println("Unable to read the Babel Server Config file");
            setNull(id);
	}
    }
   
    public String getRemoteMessage() {
	return status;
    }
    
    public boolean isActive() {
        return Active;
    }

    // Method to set the Retrieve boolean
    public void setRetrieve(boolean retrieve) {
	Retrieve = retrieve;
    }

    // Method to get the location of the babel binary directory
    public String getAppBin() {
      return Babel_Bin;
    }

    // Method to get the working directory
    public String getWorkDir() {
      return wdir;
    }

    // This method is were the babel program is run
    public boolean runApp(String[] Command) {
	try {  
	    /*test code
            for(int i = 0; i < Command.length; i++)
            System.out.println(Command[i]); */  
 
            Process process = Runtime.getRuntime().exec(Command);
            process.waitFor();
            return true;
	}   

        catch(Exception e) {
	    System.out.println("An exception occur : " + e);
            setNull(id);               
	}      
      return false;
    }

    
    /**
     * Private methods from this point on.
     *
     */	
}



