
/**
 * CCServer.java
 * This is the interface to ChemConsole Server
 *
 * Created: Tue May 25 11:32:03 1999
 *
 * @author Nathan Stevens
 * @version 0.4 July-99
 */
import java.rmi.*;

public interface CCServer extends Remote {
    /**
     * The Application server specific methods
     **/

    // Method to start the application server
    public int startAppServer(String s) throws RemoteException;

    // Method that returns the message to client
    public String getRemoteMessage(int nid) throws RemoteException;
   
    // Method to return the status of a runing application server
    public String[] getStatus(int nid) throws RemoteException;

    // Methods to get files
    public byte[] getFile(int nid, String filename) throws RemoteException;

    //Method to send files
    public boolean putFile(int nid, byte[] fileArray, String filename) throws RemoteException;

    // Method to delete
    public boolean delFile(int nid, String filename) throws RemoteException;

    // Method to stop the App Server
    public void Stop(int nid) throws RemoteException;
 
    // Method to a current process 
    public void StopJob(int nid) throws RemoteException;
 
    // get the prgram binary location
    public String getAppBin(int nid) throws RemoteException;

    // Get the working directory
    public String getWorkDir(int nid) throws RemoteException;

    // Method to see if server is active
    public boolean isActive(int nid) throws RemoteException;
 
    // Metohd to run app
    public boolean runApp(int nid, String[] c) throws RemoteException;

    //Method to get the Server stats
    public String[] getServerStats(int nid) throws RemoteException;
  
    // method to get return a list of file in working directory
    public String[] getFileList(int nid, String name, String extention) throws RemoteException;

    // method to tell server if client wants results
    public void setRetrieve(int nid, boolean r) throws RemoteException;

    /** 
    * The Utility Server specific methods
    **/
    public int startUtilityServer() throws RemoteException;

    // This method set the type of file and the server id  
    public boolean setFileTypeID(int nid, String filetype, int serverID) throws RemoteException;

    /**
     * The Config Server specific Methods
     **/
    public int startConfigServer() throws RemoteException;
 
    public boolean isPassWord(String s) throws RemoteException;

    // getter methods
    public String[] getMainCfg(int nid) throws RemoteException;
  
    public String[] getBabelCfg(int nid) throws RemoteException;
  
    public String[] getMopacCfg(int nid) throws RemoteException;

    public String[] getGaussianCfg(int nid) throws RemoteException;
  
    // setter methods
    public void setMainCfg(int nid, String[] cfg) throws RemoteException;    

    public void setBabelCfg(int nid, String[] cfg) throws RemoteException;

    public void setMopacCfg(int nid, String[] cfg) throws RemoteException;

    public void setGaussianCfg(int nid, String[] cfg) throws RemoteException;    
}  





