
/**
 * CCServerImpl.java
 * This is the class that actually implements the interface to native apps
 *
 * Created: Tue May 25 12:35:20 1999
 *
 * @author Nathan Stevens
 * @version 0.4 July-99
 */
import java.io.*;
import java.rmi.*;

public class CCServerImpl extends Thread {
    
    private byte[] fa;
    public CCServerManager ccsm;

    public void setSM(CCServerManager ccsm) {
	// Set the Server Manager
        this.ccsm = ccsm;
    }
  
    // Dummy run method
    public void run() 
    { 
      try
	{
          while(true)
	    {
              sleep(Long.MAX_VALUE);
	    }
	}
      catch(InterruptedException ie){}
    }

    // Dummy getStatus Method! rename to getRemoteMessage()
    public String getRemoteMessage()
    {
	// You should never see this message
        errPrint("getStatus");
	String blah = "s";
        return blah;
    }

    // Dummy getStatus method
    public String[] getStatus() {
	errPrint("getStatus");
        String[] blah = {"blah", "blah"};
        return blah;
    }
   
    // Dummy stop job method
    public void StopJob() { 
	errPrint("StopJob");    
}
  
    // Dummy isActive
    public boolean isActive()
    {
        errPrint("isActive");
	return false;
    }

    // Dummy runApp method
    public boolean runApp(String[] command)
    {
        System.out.println("runApp");
	return false;
    }
    
    // Dummy getAppBin method
    public String getAppBin()
    {
        System.out.println("getAppBin");
        return "s";
    }

    // Dummy get working directory method
    public String getWorkDir()
    {
        System.out.println("getWorkDir");  
        return "s";
    }
      
    // The put file method used by the other threads so I must be synchronized
    public boolean putFile(byte[] fileArray, String filename)
    {
      try
	{
          File nf = new File(filename);
          BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(nf));
         
          out.write(fileArray);

          out.flush();
          out.close();
	}
      catch(IOException e)
	{
          System.out.println(e.toString());
          return false;
	}

      return true;
    }  

    //Method to get file
    public byte[] getFile(String filename)
    {
      //Create the file object and see if it exist
      try
	{
          File nf = new File(filename);
          if(nf.isFile() && nf.canRead())
	    {
              fa = new byte[(int)nf.length()];
              BufferedInputStream in = new BufferedInputStream(new FileInputStream(nf));
             
	      // might hava a problem with this
              //for(int i = 0; i < fa.length; i++)
              in.read(fa);

              in.close();
	    }
	}
      catch(IOException e)
	{
          System.out.println(e.toString());
	}              
      return fa;
    }

    public boolean delFile(String filename)
    {
	// Construct a file object
        File delfile = new File(filename);
        
	// Check to see if file exist and is writable
        if(delfile.isFile() && delfile.canWrite()) {
	    return delfile.delete();
	}
        else { return false; }
    }
  
    //method to list the files in a directory  
    public String[] getFileList(String wdir, String name, String extension)
    {
      // create the file object 

      String[] contents;
      FilenameFilter select = new FileListFilter(name, extension);
      File workDir = new File(wdir);
     
      contents = workDir.list(select);
      return contents;      
    }

    // Method to set the thread to null
    public void setNull(int id)
    {
      try
	{     
           ccsm.Stop(id);
	}
      catch(RemoteException re) {
	  System.out.println(re.toString());
      }                 
    }

    // Method to tell the Server thread wheather to wait for the client to
    // get the results or just stop when it is done
    public void setRetrieve(boolean r) { 
	errPrint("setRetrieve");
    }

    /**
     *  Methods for Utility Servers
     */

    // Dummy Method to set the filetype and server ID
    public boolean setFileTypeID(String filetype, int serverID)  {
        errPrint("setFiletypeID"); 
	return false; }

    // Method to return the server stats to clients
    public String[] getServerStats() {
	return ccsm.getStats(); 
    }

    // Method to print an error to the System.out.println
    private void errPrint(String method) {
	System.out.println("The " + method + " called in the base class");
    }
}











