
/**
 * CCServerManager.java
 * This class manages the CCServerImpl Threads 
 *
 * Created: Tue May 25 12:00:22 1999
 *
 * @author Nathan Stevens
 * @version 0.4 July-99
 */
import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;
import java.io.*;
import java.util.*;
import java.text.*;

public class CCServerManager extends UnicastRemoteObject implements
    CCServer {
    
    private int MAX_GAUSS;
    private int MAX_MOPAC;
    private int MAX_BABEL;
    private int MAXTHREADS, MAXUTHREADS;    
    private static boolean LOG_FILE;
    private int bc, mc, gc, uc;
    private CCServerImpl[] threads;
    private int id, uid, cid;
    private static String mdir = "Mwork";
    private File mdf;
    private static File conf = new File("Config/main.cfg");
    private static File logfile;
    private static TextOutputFile lf;
    private static boolean verbose;
    private String[] blah = {"blah", "blah"};   //Remove later 
    
    public CCServerManager() throws RemoteException {
	// read in config file and set job type
        if(conf.isFile()) {
	    TextInputFile f = new TextInputFile(conf);

            MAX_BABEL = f.readInt();
            MAX_MOPAC = f.readInt();      
            MAX_GAUSS = f.readInt();
            LOG_FILE  = f.readBoolean();

	    f.close();
          
            MAXTHREADS = MAX_GAUSS + MAX_MOPAC + MAX_BABEL;
            MAXUTHREADS = MAXTHREADS*2;
	}
        else {
	    System.out.println("Unable to read Config file " + conf + 
                             "\nProgram Terminated.");
            System.exit(1);
	} 

	// create an array of all the application threads
        threads = new CCServerImpl[MAXUTHREADS + 1];
    }

    // Start the application server 
    public int startAppServer(String s) throws RemoteException {
	// Synchronize this logic to prevent collisions
        synchronized(threads) {
	    if(s.equals("babel")) {
		for(id = 0; id < MAX_BABEL; id++) {
		    if(threads[id] == null)          
			break;
		}    
	        // if no emty slots found alert client
		if(id >= MAX_BABEL) {
		    return -1;
		}
	        //create the new thread
                threads[id] = new BabelServer(id);
                   
	        // start the thread
                threads[id].setDaemon(true);
                threads[id].start();
                threads[id].setSM(this);		   
	    }

	    else if(s.equals("mopac")) {
                for(id = MAX_BABEL; id < MAX_BABEL + MAX_MOPAC; id++) {
		    if(threads[id] == null) {
			// create a working directory for mopac to run in.
                        mdf = new File(mdir + id);
                        if(!mdf.isDirectory()) {
			    mdf.mkdir();
                            break;
			}
                        break;                       
		    }
		}
                   
		// if no emty slots found alert client
                if(id >= MAX_BABEL + MAX_MOPAC) {
                    return -1; 
		}

		// create the new thread
                threads[id] = new MopacServer(id, mdf.toString() + "/");
                   
		// start the thread
                threads[id].setDaemon(true);
                threads[id].start();
                threads[id].setSM(this);    
	    }

            else if(s.equals("gaussain")) {
		for(id = MAX_BABEL + MAX_MOPAC; id < MAXTHREADS; id++) {
		    if(threads[id] == null)
			break;
		}
                   
		// if no emty slots found alert client
                if(id >= MAXTHREADS) {
                   return -1;
		}

	       // create the new thread
               threads[id] = new GaussianServer(id);
                   
	       // start the thread
               threads[id].setDaemon(true);
               threads[id].start();
               threads[id].setSM(this);
        
	    }
	}
    	   
        if(verbose)
	    printStats();
        if(LOG_FILE)
	    printLogFile();
      
        return id;
    }

    // Method to start utilty server
    public int startUtilityServer() throws RemoteException {
        // Synchronize this logic to prevent colision
	synchronized (threads) {
	    for(uid = MAXTHREADS; uid < MAXUTHREADS; uid++) {
		if(threads[uid] == null)
		    break;
	    }
          
            // If no empty slots were found, generate an error
            if(uid >= MAXUTHREADS) {
                return -1;
	    }

	    // Create a new Thread nad store it
            threads[uid]  = new UtilityServer(uid);
	}
      
        // start the thread and so on
        threads[uid].setDaemon(true);
        threads[uid].start();
        threads[uid].setSM(this);

        // return the threads identifier
        if(verbose)
	    printStats();
        if(LOG_FILE)
            printLogFile();

        return uid;
    }

    // Method to start the Configuration server
    public int startConfigServer() throws RemoteException {
	synchronized(threads) {
            for(int cid = MAXUTHREADS; cid < threads.length; cid++) {
              if(threads[cid] == null)
                break;
	    }

            if(cid >= threads.length) {
                return -1;
	    }
         
	    // create the configuration thread
            threads[cid] = new ConfigServer(cid);
	  
	    // now start the thread

	    //return the id
            return cid;
	}
    }

    // method to return the server  message to clients
    public String getRemoteMessage(int nid) throws RemoteException {
        return threads[nid].getRemoteMessage();
    }

    // Method to get the status of a runing Application Server
    public String[] getStatus(int nid) throws RemoteException {
      return threads[nid].getStatus();
    }
  
    // Method to return a file for appserver client
    public byte[] getFile(int nid, String filename) throws RemoteException {
        String dir = threads[nid].getWorkDir() + "/";
        return threads[nid].getFile(dir + filename);
    }

    // Method to put files
    public boolean putFile(int nid, byte[] fileArray, String filename) throws RemoteException {
        String dir = threads[nid].getWorkDir() + "/";
        return threads[nid].putFile(fileArray, dir + filename);
    }

    // Method to remove a file
    public boolean delFile(int nid, String filename) throws RemoteException {
        String dir = threads[nid].getWorkDir() + "/"; 
        return threads[nid].delFile(dir + filename);
    }

    // Method to stop the current thread and reset it
    public void Stop(int nid) throws RemoteException {
      //Shut down the thread
      threads[nid].stop();
      threads[nid] = null;
    }

    // Method to stop a current job
    public void StopJob(int nid) throws RemoteException {
        threads[nid].StopJob();
    }

    // Method to see if server is active or not
    public boolean isActive(int nid) throws RemoteException {
        return threads[nid].isActive();
    }      

    // Method to run the application
    public boolean runApp(int nid, String[] command) throws RemoteException {
        return threads[nid].runApp(command);
    }

    // Method to return the location of App binary to client
    public String getAppBin(int nid) throws RemoteException {
        return threads[nid].getAppBin();
    }

    // Method to get the Server Stats
    synchronized public String[] getStats() {
        boolean check;           // this checks to see weather to check for
	                         // to see if server is active 

	String bActive = null;   // indicate weather babel is active
        String mActive = null;   // "        "       mopac "  "
        String gActive = null;   // "        "       gaussian "  "

        bc = 0;                  // number of babel clients
        mc = 0;                  // number of mopac client
        gc = 0;                  // number of gaussin clients connected
        uc = 0;                  // number of utility clients connected
        int tc;                  // The total number app server clients
        int maxc;                // The maximum number of clients
        int maxu;                // The maximum number od utililty clients  
 
        // get the number of babel clients connected and if it is active 
        check = true;

        for(int i = 0; i < MAX_BABEL; i++) {
	    if(threads[i] != null)
		bc++; 
            else if(check) {
		// create a babel server thread so that we check to see 
		// if it is active or not.
                threads[i] = new BabelServer();
                threads[i].start();

                if(threads[i].isActive())
		    bActive = "YES";
                else 
                    bActive = "NO";
        
		// now stop the Thread
                stopThread(i);

		// set check to false so that we don't do this again
                check  = false;
	    }
	}
       
	// get the number of mopac clients connected
        check = true;      

        for(int i = MAX_BABEL; i < MAX_BABEL + MAX_MOPAC; i++) {
	    if(threads[i] != null)
		mc++;
            else if(check) {
		// create a Mopac server thread so that we check to see if 
                // it is active or not.
                threads[i] = new MopacServer();
                threads[i].start();

                if(threads[i].isActive())
		    mActive = "YES";
                else 
		    mActive = "NO";
        
	        // now stop the Thread
                stopThread(i);

	        // set check to false so that we don't do this again
                check  = false;
	    }
	}
         
	// get the number of gaussian clients connected
        check = true;

        for(int i = MAX_BABEL + MAX_MOPAC; i < MAXTHREADS; i++) {
	    if(threads[i] != null)
		gc++;
            else if(check) {
	        // create a babel server thread so that we check to see if 
		// it is active or not.
                threads[i] = new GaussianServer();
                threads[i].start();

                if(threads[i].isActive())
		    gActive = "YES";
                else 
                    gActive = "NO";
        
	        // now stop the Thread
                stopThread(i);

	        // set check to false so that we don't do this again
                check  = false;
	    }
	}
  
        // Now get the number of utility clients connected
        for(int i = MAXTHREADS; i < MAXUTHREADS; i++) {
	    if(threads[i] != null)
		uc++;
	}

        // Now get the total number of client
        tc = bc + mc + gc;
      
        maxc = MAXTHREADS;
        maxu = MAXUTHREADS - MAXTHREADS;
      
        String[] stats = {String.valueOf(maxc), String.valueOf(maxu), 
                          String.valueOf(tc),   
                          bc +" / "+ MAX_BABEL, bActive, 
                          mc +" / "+ MAX_MOPAC, mActive,  
                          gc +" / "+ MAX_GAUSS, gActive,
                          uc +" / "+ maxu};
      
	return stats;
    }

    // Method to print out the Stats of server to System.out
    private void printStats() {
	// Print the date nad time
        System.out.println("\nThe Date and time is : " + getDateTime());
	
        String[] stats = getStats();
      
        System.out.println("\nThe maximum number of Application Server"+ 
                             " clients allowed  : " + stats[0]);
        System.out.println("The maximum number of Utility Server clients" +
                             " allowed : " + stats[1]);
        System.out.println("The number Application Server clients" +
                             " currently connected : " + stats[2]);
       
        System.out.println("\nServer\t\t\t# of client(s)\t\t\tActive");
        System.out.println("======\t\t\t==============\t\t\t======");
        System.out.println("\nBabel\t\t\t" +stats[3]+ "\t\t\t\t"+ stats[4]);  
        System.out.println("Mopac\t\t\t"   +stats[5]+ "\t\t\t\t" + stats[6]);
        System.out.println("Gaussian\t\t"  +stats[7]+ "\t\t\t\t" + stats[8]);
        System.out.println("Utility\t\t\t" +stats[9]+ "\t\t\t\tN/A");
    }
  
    // Method to get the time and date
    private static String getDateTime() {

      Date date = new Date();
      DateFormat fmt = DateFormat.getDateTimeInstance();
      
      return fmt.format(date);
    }

    // Method to print to the log file "CCSlog.txt".
    private void printLogFile() {

	// now print the date
        lf.println("\nThe Date and Time is : " + getDateTime());
      
        // now print the number of clients that are connected and state
        String[] stats = getStats();

        lf.println("\nThe maximum number of Application Server"+ 
                             " clients allowed  : " + stats[0]);
        lf.println("The maximum number of Utility Server clients" +
                             " allowed : " + stats[1]);
        lf.println("The number Application Server clients" +
                             " currently connected : " + stats[2]);
       
        lf.println("\nServer\t\t\t# of client(s)\t\t\tActive");
        lf.println("======\t\t\t==============\t\t\t======");
        lf.println("\nBabel\t\t\t" +stats[3]+ "\t\t\t\t"+ stats[4]);  
        lf.println("Mopac\t\t\t"   +stats[5]+ "\t\t\t\t" + stats[6]);
        lf.println("Gaussian\t\t"  +stats[7]+ "\t\t\t\t" + stats[8]);
        lf.println("Utility\t\t\t" +stats[9]+ "\t\t\t\tN/A");                  
    }

    // Method to get the working directory of application
    public String getWorkDir(int nid) throws RemoteException {
        return threads[nid].getWorkDir();
    }

    public String[] getFileList(int nid, String name, String extension) throws RemoteException {
        String dir = threads[nid].getWorkDir();
        return threads[nid].getFileList(dir, name, extension);
    }

    // Method to set the retrieve boolean 
    public void setRetrieve(int nid, boolean r) throws RemoteException {
       threads[nid].setRetrieve(r);
    }

    /**
    * The Utility Server specific methods
    **/

    // Method to set the babel directory to lookin when getting output files
    public boolean setFileTypeID(int nid, String filetype, int serverID) throws RemoteException {
	// call the threads similar method
        return threads[nid].setFileTypeID(filetype, serverID);
    }

    // Method to return the server stats to the clients
    public String[] getServerStats(int nid) throws RemoteException {

	return threads[nid].getServerStats();
    }

    // Methods to return some privat data variable of this class

    public int getMaxBabel() { return MAX_BABEL; }

    public int getMaxMopac() { return MAX_MOPAC; }
   
    public int getMaxGauss() { return MAX_GAUSS; } 
    
  
    /**
     * The ConfigServer specific methods
     **/
  
    // Method to check password
    synchronized public boolean isPassWord(String s) throws RemoteException {
        // code
        return true;
    }

    // Method to get the values in the config files
    public String[] getMainCfg(int nid) throws RemoteException {
        // code
        return blah;
    }   

    public String[] getBabelCfg(int nid) throws RemoteException {
        // code
        return blah;
    }

    public String[] getMopacCfg(int nid) throws RemoteException {
        // code
        return blah;
    }

    public String[] getGaussianCfg(int nid) throws RemoteException {
        // code
        return blah;
    }

    // Method to set the values of the config files
    public void setMainCfg(int nid, String[] cfg) throws RemoteException {
      // code
    }

    public void setBabelCfg(int nid, String[] cfg) throws RemoteException {
      // code
    }

    public void setMopacCfg(int nid, String[] cfg) throws RemoteException {
      // code
    }

    public void setGaussianCfg(int nid, String[] cfg) throws RemoteException {
      // code
    }

    /** 
     * Private methods from this point on...
     */
    
    // method to stop a thread
    private void stopThread(int nid) {
	try {
          Stop(nid); 
	}
        catch(RemoteException re) {
	    System.out.println(re.toString());
	}
    }

    // The main method to start the object as a background process and
    // bind itself to the registry
    public static void main(String[] args) {

        // check to see wheather we are in verbose mode of not
        if(args.length != 0 && args[0].equals("-v"))
	    verbose = true;
        else
            verbose = false;
        
        System.out.println("Starting ChemConsole Server......");
      
        // Install the security manager
        System.setSecurityManager(new RMISecurityManager());
      
        try {
	    // Instantiate and register the remote object
            CCServerManager ccm = new CCServerManager();
            Naming.rebind("ccserver", ccm);
            System.out.println("ChemConsole Server is running.");

	    // Check to see whether to print to the log file
            if(LOG_FILE) {
                logfile  = new File("CCSlog.txt");
                lf = new TextOutputFile(logfile, true);

                // print the message that is printed every time the server is
	        // started with log file set to true
                String smessage = new String("ChemConsole Server Version 0.4"+
                " Log File." + "\nThe Current date and time is : " + 
                getDateTime() 
                + "\nThis message is printed every time"+
                " the ChemConsole Server starts. ");

                lf.println(smessage + "\n");
	    } 

            if(verbose)
                ccm.printStats();
	}
        catch(Exception e) {
	    System.out.println("CCServerManager.main: an exception " +
                             "occurred: " + e.getMessage());
            e.printStackTrace();
	}
    }    
}  
  











