
/**
 * MopacServer.java
 *
 *
 * Created: Tue May 25 16:36:25 1999
 *
 * @author Nathan Stevens
 * @version 0.4 July-99
 */
import java.io.*;

public class MopacServer extends CCServerImpl {

    private String[] status;
    private String wdir = null;
    private static File conf = new File("Config/mopac.cfg");
    private boolean Active = true;
    private String Mopac_Bin = "mopac";
    private boolean REM_EXT  = true;
    private Timer tm1, tm2;
    private String[] com;
    private Process process;
    private boolean retrieve = true;          // default setting
    private int id;
 
    // default constructor
    public MopacServer() {
      this(500, "blah");
    }

    public MopacServer(int id, String wdir) {
	this.id = id;
        this.wdir = wdir;

	// Read in config file if it exist or quit if it doesn't
        if(conf.isFile()) {
	    TextInputFile f = new TextInputFile(conf);
            Active = f.readBoolean();
            Mopac_Bin = f.readString();
            REM_EXT = f.readBoolean();
          
	    // Close the file
            f.close();
	}
        else {
	    System.out.println("Unable to read config file, Mopac Server " + 
                               "exiting.");
            setNull(id);
	}
    }

    // Method to start execution of mopac on server
    public boolean runApp(String[] command) {

	tm1 = new Timer();
      
        com = new String[3];
        com[0] = Mopac_Bin;
        com[2] = wdir;
      
	// start the main timer
        tm1.start();
  
        for(int i = 0; i < command.length; i++) {
	    if(REM_EXT) {
		int fl = command[i].length() - 4;
                com[1] = command[i].substring(0,fl);
	    }
            else { 
		com[1] = command[i];
	    }

            tm2 = new Timer();
              
	    // Now execute the command and wait for it to finish
            try {
                process =  Runtime.getRuntime().exec(com);
                tm2.start();
                process.waitFor();
                tm2.stop();
	    }
            catch(IOException ioe) {
		System.out.println("Mopac Server Error : " + ioe);
		setNull(id);
                return false;
	    }
	    catch(InterruptedException e) {
		System.out.println("Mopac Error : " + e);
                setNull(id);
                return false;
	    }    
	}

        tm1.stop();
      
        // See wheather to kill the thread
        if(retrieve == false) { 
	    setNull(id); }

        // return true
        return true;
    }    
      
    public String[] getStatus() {              
	int[] time1 = tm1.getMinSec();
        int[] time2 = tm2.getMinSec();
      
        String t1 = time1[0] + "." + time1[1] + " Min";
        String t2 = time2[0] + "." + time2[1] + " Min";    

        String[] status = {"Mopac Server\n",
                          "The Current Job is " + com[1],
                          "It has been runing for " + t2,
                          "The Total time  is " + t1};      
        return status;
    }

    public boolean isActive() {
      return Active;
    }  
  
    // Method to stop the current process
    public void StopJob() {
      process.destroy();
    }

    // Method to set the to wheather to the client wnat to get the results
    public void setRetrieve(boolean r) {
	retrieve = r;
    }
  
    // Method to return working directory
    public String getWorkDir() {
        return wdir;
    }
  	
} 









