
/**
 * UtilityServer.java
 * This is the utility server class, it is used by the clients fileGetter and
 * getStats modules
 * Created: Sun Jun 20 10:50:56 1999
 *
 * @author Nathan Stevens
 * @version 0.4 July-99
 */

public class UtilityServer extends CCServerImpl {
      
    private String wdir;
    private int uid;
   
    public UtilityServer(int uid) {
        this.uid = uid;
    }  
  
    // Method to set the the working directory 
    public boolean setFileTypeID(String filetype, int serverID) {
     
	//get the valid Application Server id ranges and set them
        int MAX_BABEL = super.ccsm.getMaxBabel();
        int MAX_MOPAC = super.ccsm.getMaxMopac();
        int MAX_GAUSS = super.ccsm.getMaxGauss();
       
        int MAXTHREADS = MAX_BABEL + MAX_MOPAC + MAX_GAUSS;	


	if(filetype.equals("babel")) {
	    // Check the server ID
            if(serverID >= 0 && serverID < MAX_BABEL) { 
		//set the working directory to the babel work directory 
                wdir = "Bwork";

                return true;
	    }
            else { return false; }           
	}

        else if(filetype.equals("mopac")) {
	    //check the server ID
            if(serverID >= MAX_BABEL && serverID < (MAX_MOPAC + MAX_BABEL)) {
		wdir = "Mwork" + serverID;

                return true;
	    }
            else { return false; }
	}
        
        else if(filetype.equals("gaussian")) {
	    //Check the server ID
	    if(serverID >= (MAX_MOPAC + MAX_BABEL) && serverID < MAXTHREADS) {
              wdir = "Gwork";
              return true;
	    }
            else { return false; }
	}
        else { return false; }
    }

    // Method to return the working directory
    public String getWorkDir() {
	return wdir;
    }
         
} // UtilityServer



