/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Vector;

public class BabelApp
extends Thread {
    private String[] Command;
    public String Mode;
    public String BABEL_BIN;
    private int intype;
    public String inputType;
    public String infile;
    public String infile2;
    public String keyw1;
    private int outtype;
    public String outputType;
    public String outfile;
    public String keyw2;
    public String rnum;
    public String adh;
    private String itype;
    private String otype;
    private Process process;
    private ChemConsoleClient cl;
    public String hostname;
    private int id;
    private StatusPanel sp;
    public boolean isRetrieve;
    private ChemMessage m = new ChemMessage();
    public boolean alert;

    BabelApp() {
        this(true);
    }

    BabelApp(boolean bl) {
        this.alert = bl;
    }

    public void run() {
        try {
            this.intype = Integer.parseInt(this.inputType);
            this.outtype = Integer.parseInt(this.outputType);
        }
        catch (NumberFormatException numberFormatException) {
            String[] stringArray = new String[]{"Unable to Convert Input or Output entry", "to an Integer. Please check values. "};
            this.m.errPrint(stringArray, "NumberFormat Error");
            this.stop();
        }
        this.checkfile();
    }

    private void checkfile() {
        File file = new File(this.infile);
        String[] stringArray = new String[]{"The input file " + this.infile + " doesn't exist.", "Please check that the correct inputfile name  was", "entered..."};
        if (file.isFile()) {
            this.setCommand();
            return;
        }
        this.m.errPrint(stringArray, "File Error");
        this.stop();
    }

    private void setCommand() {
        this.itype = "-i" + this.getInputType();
        this.otype = "-o" + this.getOutputType();
        Vector<String> vector = new Vector<String>();
        if (this.Mode.equals("local")) {
            vector.addElement(this.BABEL_BIN);
            vector.addElement(this.itype);
            vector.addElement(this.infile);
            vector.addElement(this.otype);
            vector.addElement(this.outfile);
        } else if (this.Mode.equals("network")) {
            this.sp = new StatusPanel("Babel Server(" + this.hostname + ") Status");
            this.sp.println("Contacting Babel Server...");
            try {
                this.cl = new ChemConsoleClient("babel", this.hostname);
                this.cl.setDaemon(true);
                this.cl.start();
                if (this.cl.server != null) {
                    this.id = this.cl.startAppServer();
                    if (this.id != -1) {
                        if (this.cl.isActive(this.id)) {
                            this.sp.println("Connected to Babel Server(" + this.id + ")...");
                            String string = String.valueOf(this.cl.getWorkDir(this.id)) + "/";
                            vector.addElement(this.cl.getAppBin(this.id));
                            vector.addElement(this.itype);
                            vector.addElement(String.valueOf(string) + this.infile2);
                            vector.addElement(this.otype);
                            vector.addElement(String.valueOf(string) + this.outfile);
                        } else {
                            this.sp.println("Babel Services are not provided by this Server");
                            this.cl.Stop(this.id);
                            this.stop();
                        }
                    } else {
                        this.sp.println("The Babel Server has reached the maximum number of allowed clients.\nTry Back later.");
                        this.stop();
                    }
                } else {
                    this.sp.println("Connnection to Server refused");
                    this.stop();
                }
            }
            catch (RemoteException remoteException) {
                this.m.errPrint(remoteException.toString(), "Remote Exception");
                this.stop();
            }
        }
        if (this.keyw2 != null) {
            vector.addElement(this.keyw2);
        }
        if (this.rnum != null) {
            vector.insertElementAt(this.rnum, 3);
        }
        if (this.adh != null) {
            vector.insertElementAt(this.adh, 3);
        }
        if (this.keyw1 != null) {
            vector.insertElementAt(this.keyw1, 3);
        }
        this.Command = new String[vector.size()];
        vector.copyInto(this.Command);
        this.runApp();
    }

    private String getInputType() {
        switch (this.intype) {
            case 1: {
                return "alc";
            }
            case 2: {
                return "prep";
            }
            case 3: {
                return "bs";
            }
            case 4: {
                return "bgf";
            }
            case 5: {
                return "car";
            }
            case 6: {
                return "boog";
            }
            case 7: {
                return "caccrt";
            }
            case 8: {
                return "cadpac";
            }
            case 9: {
                return "charmm";
            }
            case 10: {
                return "c3d1";
            }
            case 11: {
                return "c3d2";
            }
            case 12: {
                return "cssr";
            }
            case 13: {
                return "fdat";
            }
            case 14: {
                return "gstat";
            }
            case 15: {
                return "dock";
            }
            case 16: {
                return "dpdb";
            }
            case 17: {
                return "feat";
            }
            case 18: {
                return "fract";
            }
            case 19: {
                return "gamout";
            }
            case 20: {
                return "gzmat";
            }
            case 21: {
                return "guout";
            }
            case 22: {
                return "g94";
            }
            case 23: {
                return "gr96A";
            }
            case 24: {
                return "gr96N";
            }
            case 25: {
                return "hin";
            }
            case 26: {
                return "sdf";
            }
            case 27: {
                return "m3d";
            }
            case 28: {
                return "macmol";
            }
            case 29: {
                return "macmod";
            }
            case 30: {
                return "mocro";
            }
            case 31: {
                return "mm2in";
            }
            case 32: {
                return "mm2out";
            }
            case 33: {
                return "mm3";
            }
            case 34: {
                return "mmads";
            }
            case 35: {
                return "mdl";
            }
            case 36: {
                return "molen";
            }
            case 37: {
                return "mopcrt";
            }
            case 38: {
                return "mopint";
            }
            case 39: {
                return "mopout";
            }
            case 40: {
                return "pcmod";
            }
            case 41: {
                return "pdb";
            }
            case 42: {
                return "psin";
            }
            case 43: {
                return "psout";
            }
            case 44: {
                return "msf";
            }
            case 45: {
                return "schakal";
            }
            case 46: {
                return "shelx";
            }
            case 47: {
                return "smiles";
            }
            case 48: {
                return "spar";
            }
            case 49: {
                return "semi";
            }
            case 50: {
                return "spmm";
            }
            case 51: {
                return "mol";
            }
            case 52: {
                return "mol2";
            }
            case 53: {
                return "wiz";
            }
            case 54: {
                return "unixyz";
            }
            case 55: {
                return "xyz";
            }
            case 56: {
                return "xed";
            }
        }
        String[] stringArray = new String[]{"This is not a supported input type"};
        this.m.errPrint(stringArray, "Input Type Error");
        this.stop();
        return "xxx";
    }

    private String getOutputType() {
        switch (this.outtype) {
            case 1: {
                return "diag";
            }
            case 2: {
                return "alc";
            }
            case 3: {
                return "bs";
            }
            case 4: {
                return "bgf";
            }
            case 5: {
                return "bmin";
            }
            case 6: {
                return "box";
            }
            case 7: {
                return "caccrt";
            }
            case 8: {
                return "cacint";
            }
            case 9: {
                return "cache";
            }
            case 10: {
                return "c3d1";
            }
            case 11: {
                return "c3d2";
            }
            case 12: {
                return "cdct";
            }
            case 13: {
                return "dock";
            }
            case 14: {
                return "wiz";
            }
            case 15: {
                return "contmp";
            }
            case 16: {
                return "cssr";
            }
            case 17: {
                return "dpdb";
            }
            case 18: {
                return "feat";
            }
            case 19: {
                return "fhz";
            }
            case 20: {
                return "gamin";
            }
            case 21: {
                return "gcart";
            }
            case 22: {
                return "gzmart";
            }
            case 23: {
                return "gotmp";
            }
            case 24: {
                return "gr96A";
            }
            case 25: {
                return "gr96N";
            }
            case 26: {
                return "hin";
            }
            case 27: {
                return "icon";
            }
            case 28: {
                return "idatm";
            }
            case 29: {
                return "sdf";
            }
            case 30: {
                return "m3d";
            }
            case 31: {
                return "macmol";
            }
            case 32: {
                return "macmod";
            }
            case 33: {
                return "micro";
            }
            case 34: {
                return "mm2in";
            }
            case 35: {
                return "mm2out";
            }
            case 36: {
                return "mm3";
            }
            case 37: {
                return "mmads";
            }
            case 38: {
                return "mdl";
            }
            case 39: {
                return "miv";
            }
            case 40: {
                return "mopcrt";
            }
            case 41: {
                return "mopint";
            }
            case 42: {
                return "csr";
            }
            case 43: {
                return "pcmod";
            }
            case 44: {
                return "pdb";
            }
            case 45: {
                return "psz";
            }
            case 46: {
                return "psc";
            }
            case 47: {
                return "report";
            }
            case 48: {
                return "smiles";
            }
            case 49: {
                return "spar";
            }
            case 50: {
                return "mol";
            }
            case 51: {
                return "mol2";
            }
            case 52: {
                return "maccs";
            }
            case 53: {
                return "torlist";
            }
            case 54: {
                return "tinker";
            }
            case 55: {
                return "unixyz";
            }
            case 56: {
                return "xyz";
            }
            case 57: {
                return "xed";
            }
        }
        String[] stringArray = new String[]{"This is not a supported output type"};
        this.m.errPrint(stringArray, "Output Type Error");
        this.stop();
        return "xxx";
    }

    private void runApp() {
        block11: {
            if (this.Mode.equals("local")) {
                try {
                    this.process = Runtime.getRuntime().exec(this.Command);
                    this.process.waitFor();
                    if (this.alert) {
                        this.m.msgPrint("Babel Conversion of " + this.infile + " completed", "Bable Status");
                        return;
                    }
                    break block11;
                }
                catch (IOException iOException) {
                    this.m.errPrint(iOException.toString(), "IOExcetion");
                    this.stop();
                    return;
                }
                catch (Exception exception) {
                    this.m.errPrint(exception.toString(), "BabelApp Thread Exception");
                    this.stop();
                    return;
                }
            }
            if (this.Mode.equals("network")) {
                try {
                    this.sp.println("Sending input file, " + this.infile2 + " ,to Server.");
                    if (this.cl.putFile(this.id, this.infile, this.infile2)) {
                        this.sp.println("Executing Babel");
                        if (this.cl.runApp(this.id, this.Command)) {
                            if (this.isRetrieve) {
                                this.sp.println("Retrieving the output file, " + this.outfile + " ,from Server.");
                                this.cl.getFile(this.id, this.outfile);
                                this.cl.Stop(this.id);
                                this.stop();
                                return;
                            }
                            this.sp.println("The Output file(s) will be left on the server.");
                            this.cl.Stop(this.id);
                            this.stop();
                            return;
                        }
                        this.sp.println("Babel failed to execute");
                        this.cl.Stop(this.id);
                        this.stop();
                        return;
                    }
                    this.sp.println("Can't send input file");
                    this.cl.Stop(this.id);
                    this.stop();
                    return;
                }
                catch (RemoteException remoteException) {
                    this.sp.println("Server Error : " + remoteException);
                    this.stop();
                    return;
                }
            }
        }
    }
}

