/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;

public class ChemConsoleClient
extends Thread {
    private String JobType;
    private String hostname;
    public CCServer server;
    private byte[] fa;

    public ChemConsoleClient(String string, String string2) throws RemoteException {
        this.JobType = string;
        this.hostname = string2;
        String string3 = "rmi://" + string2 + ":1099/ccserver";
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            this.server = (CCServer)Naming.lookup(string3);
            return;
        }
        catch (Exception exception) {
            System.err.println("Cannot connect to RMI registry for " + string3);
            System.out.println(exception.toString());
            this.stop();
            return;
        }
    }

    public int startAppServer() throws RemoteException {
        return this.server.startAppServer(this.JobType);
    }

    public int startUtilityServer() throws RemoteException {
        return this.server.startUtilityServer();
    }

    public int startConfigServer() throws RemoteException {
        return this.server.startUtilityServer();
    }

    public String[] getStatus(int n) throws RemoteException {
        return this.server.getStatus(n);
    }

    public String getRemoteMessage(int n) throws RemoteException {
        return this.server.getRemoteMessage(n);
    }

    public boolean getFile(int n, String string) throws RemoteException {
        this.fa = this.server.getFile(n, string);
        try {
            File file = new File(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            if (this.fa == null) {
                return false;
            }
            bufferedOutputStream.write(this.fa);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            return false;
        }
        return true;
    }

    public boolean putFile(int n, String string, String string2) throws RemoteException {
        File file = new File(string);
        try {
            if (file.isFile()) {
                byte[] byArray = new byte[(int)file.length()];
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                bufferedInputStream.read(byArray);
                return this.server.putFile(n, byArray, string2);
            }
            System.out.println("Could not find the file " + file);
            return false;
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            return false;
        }
    }

    public boolean delFile(int n, String string) throws RemoteException {
        return this.server.delFile(n, string);
    }

    public boolean isActive(int n) throws RemoteException {
        return this.server.isActive(n);
    }

    public String getAppBin(int n) throws RemoteException {
        return this.server.getAppBin(n);
    }

    public String getWorkDir(int n) throws RemoteException {
        return this.server.getWorkDir(n);
    }

    public boolean runApp(int n, String[] stringArray) throws RemoteException {
        return this.server.runApp(n, stringArray);
    }

    public void Stop(int n) throws RemoteException {
        this.server.Stop(n);
    }

    public void StopJob(int n) throws RemoteException {
        this.server.StopJob(n);
    }

    public String[] getFileList(int n, String string, String string2) throws RemoteException {
        return this.server.getFileList(n, string, string2);
    }

    public void setRetrieve(int n, boolean bl) throws RemoteException {
        this.server.setRetrieve(n, bl);
    }

    public boolean setFileTypeID(int n, int n2) throws RemoteException {
        return this.server.setFileTypeID(n, this.JobType, n2);
    }

    public String[] getServerStats(int n) throws RemoteException {
        return this.server.getServerStats(n);
    }
}

