/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.JButton;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.border.BevelBorder;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.TitledBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class DataFileEditorPanel
extends JPanel
implements ActionListener {
    private JTextArea textArea;
    private int N_ROW = 20;
    private int N_COL = 80;
    private String data;
    private Font f;
    private File file;
    private ChemDialog win;
    private ChemMessage m;
    private fDialog fd;
    private JButton bt1;
    private JButton bt2;
    private JButton bt3;
    private JButton bt4;

    public DataFileEditorPanel() {
        this("Date File");
    }

    public DataFileEditorPanel(String string) {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Component)((Object)this)).setLocation(50, 70);
        this.f = new Font("Monospaced", 0, 12);
        this.textArea = new JTextArea("", this.N_ROW, this.N_COL);
        this.textArea.setEditable(true);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setFont(this.f);
        JScrollPane jScrollPane = new JScrollPane((Component)this.textArea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        BevelBorder bevelBorder = new BevelBorder(1);
        jScrollPane.setBorder((Border)bevelBorder);
        ((Container)((Object)this)).add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        FlowLayout flowLayout = new FlowLayout(1, 50, 5);
        jPanel.setLayout(flowLayout);
        TitledBorder titledBorder = new TitledBorder("File");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(2);
        jPanel.setBorder((Border)titledBorder);
        this.bt1 = new JButton("Open");
        this.bt1.addActionListener((ActionListener)this);
        this.bt1.setActionCommand("open");
        jPanel.add((Component)this.bt1);
        this.bt2 = new JButton("Save");
        this.bt2.addActionListener((ActionListener)this);
        this.bt2.setActionCommand("save");
        jPanel.add((Component)this.bt2);
        this.bt3 = new JButton("Clear");
        this.bt3.addActionListener((ActionListener)this);
        this.bt3.setActionCommand("clear");
        jPanel.add((Component)this.bt3);
        this.bt4 = new JButton("Close");
        this.bt4.addActionListener((ActionListener)this);
        this.bt4.setActionCommand("close");
        jPanel.add((Component)this.bt4);
        ((Container)((Object)this)).add((Component)jPanel, "South");
        this.win = new ChemDialog(string, this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("open")) {
            this.getFile();
            return;
        }
        if (string.equals("save")) {
            this.saveText();
            return;
        }
        if (string.equals("close")) {
            this.win.close();
            return;
        }
        if (string.equals("clear")) {
            this.textArea.setText("");
        }
    }

    private void getFile() {
        this.fd = new fDialog((Component)((Object)this), "Input File name");
        this.fd.setBackground(this.getPanelColor());
        this.fd.show();
        String string = this.fd.getFile();
        String string2 = this.fd.getDirectory();
        File file = new File(String.valueOf(string2) + string);
        this.setFile(file);
    }

    public void setFile(File file) {
        if (file.isFile()) {
            this.file = file;
            this.readText();
            return;
        }
        this.m = new ChemMessage(this);
        this.m.errPrint("Can't find file " + file + ".", "File Error");
    }

    public void setEditable(boolean bl) {
        this.textArea.setEditable(bl);
        this.bt2.setEnabled(bl);
        this.bt3.setEnabled(bl);
    }

    private void readText() {
        String string = "";
        TextInputFile textInputFile = new TextInputFile(this.file);
        while (!textInputFile.eof()) {
            string = String.valueOf(string) + textInputFile.readLine() + "\n";
        }
        textInputFile.close();
        this.textArea.setText(string);
    }

    private void saveText() {
        String string = this.textArea.getText();
        TextOutputFile textOutputFile = new TextOutputFile(this.file);
        textOutputFile.print(string);
        textOutputFile.close();
    }

    private Color getPanelColor() {
        return ((Component)((Object)this)).getBackground();
    }
}

