/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonGroup;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JRadioButton;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.TitledBorder;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;

public class FileGetterPanel
extends JPanel
implements ActionListener,
ItemListener {
    private StatusPanel sp;
    private ChemDialog cd;
    private ChemMessage m;
    private ChemConsoleClient cl;
    private JComboBox cb;
    private JTextField tf1;
    private JTextField tf2;
    private JTextField tf3;
    private JRadioButton rd1;
    private JRadioButton rd2;
    private JRadioButton rd3;
    private String jobType;
    private String name;
    private String serverID;
    private String host;
    private int sID;

    public FileGetterPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(gridBagLayout);
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 15, 5));
        this.rd1 = new JRadioButton("Babel");
        this.rd1.addActionListener((ActionListener)this);
        this.rd1.setActionCommand("babel");
        buttonGroup.add((AbstractButton)this.rd1);
        jPanel.add((Component)this.rd1);
        this.rd2 = new JRadioButton("Mopac");
        this.rd2.addActionListener((ActionListener)this);
        this.rd2.setActionCommand("mopac");
        buttonGroup.add((AbstractButton)this.rd2);
        jPanel.add((Component)this.rd2);
        this.rd3 = new JRadioButton("Gaussian");
        this.rd3.addActionListener((ActionListener)this);
        this.rd3.setActionCommand("gaussian");
        buttonGroup.add((AbstractButton)this.rd3);
        jPanel.add((Component)this.rd3);
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.fill = 2;
        this.addPanel("Output File Type", jPanel, gridBagConstraints, gridBagLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 5));
        JLabel jLabel = new JLabel("Name : ");
        jPanel2.add((Component)jLabel);
        this.tf1 = new JTextField(20);
        jPanel2.add((Component)this.tf1);
        jLabel = new JLabel("Server ID");
        jPanel2.add((Component)jLabel);
        this.tf2 = new JTextField(3);
        jPanel2.add((Component)this.tf2);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.addPanel("File name", jPanel2, gridBagConstraints, gridBagLayout);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 5));
        serverList serverList2 = new serverList();
        this.cb = new JComboBox((Object[])serverList2.getServers());
        this.cb.addItemListener((ItemListener)this);
        jPanel3.add((Component)this.cb);
        jLabel = new JLabel("name : ");
        jPanel3.add((Component)jLabel);
        this.tf3 = new JTextField(20);
        jPanel3.add((Component)this.tf3);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.addPanel("Server", jPanel3, gridBagConstraints, gridBagLayout);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1, 15, 5));
        JButton jButton = new JButton("  OK  ");
        jButton.addActionListener((ActionListener)this);
        jButton.setActionCommand("ok");
        jPanel4.add((Component)jButton);
        jButton = new JButton("Cancel");
        jButton.addActionListener((ActionListener)this);
        jButton.setActionCommand("cancel");
        jPanel4.add((Component)jButton);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.addPanel(jPanel4, gridBagConstraints, gridBagLayout);
        this.m = new ChemMessage(this);
        this.cd = new ChemDialog("FileGetter", this);
    }

    private void addPanel(String string, JPanel jPanel, GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout) {
        TitledBorder titledBorder = new TitledBorder(string);
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(1);
        jPanel.setBorder((Border)titledBorder);
        gridBagLayout.setConstraints((Component)jPanel, gridBagConstraints);
        ((Container)((Object)this)).add((Component)jPanel);
    }

    private void addPanel(JPanel jPanel, GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout) {
        gridBagLayout.setConstraints((Component)jPanel, gridBagConstraints);
        ((Container)((Object)this)).add((Component)jPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            this.getInput();
            return;
        }
        if (string.equals("cancel")) {
            this.cd.close();
            return;
        }
        if (string.equals("babel") && this.rd1.isSelected()) {
            this.jobType = "babel";
            return;
        }
        if (string.equals("mopac") && this.rd2.isSelected()) {
            this.jobType = "mopac";
            return;
        }
        if (string.equals("gaussian") && this.rd3.isSelected()) {
            this.jobType = "gaussian";
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.cb) {
            Object object = this.cb.getSelectedItem();
            this.tf3.setText(object.toString());
        }
    }

    private void getInput() {
        this.name = this.tf1.getText();
        this.serverID = this.tf2.getText();
        this.host = this.tf3.getText();
        if (this.jobType != null && this.name.length() != 0 && this.serverID.length() != 0 && this.host.length() != 0) {
            try {
                this.sID = Integer.parseInt(this.serverID);
                this.getFiles();
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String[] stringArray = new String[]{"The Server ID is not an Integer", "Please re-enter an Integer", numberFormatException.toString()};
                this.m.errPrint(stringArray, "NumberFormat Error");
                return;
            }
        }
        String[] stringArray = new String[]{"A required value was not entered or choosen.", "Please make sure you didn't leave anything blank."};
        this.m.errPrint(stringArray, "Input Error");
    }

    private void getFiles() {
        this.sp = new StatusPanel("ChemConsoleServer@" + this.host);
        this.sp.println("Contacting Server...");
        try {
            this.cl = new ChemConsoleClient(this.jobType, this.host);
            this.cl.setDaemon(true);
            if (this.cl.server != null) {
                int n = this.cl.startUtilityServer();
                if (n != -1) {
                    if (this.cl.setFileTypeID(n, this.sID)) {
                        String[] stringArray = this.cl.getFileList(n, this.name, null);
                        if (stringArray != null && stringArray.length != 0) {
                            this.sp.println("Getting " + (stringArray.length > 1 ? "files" : "file") + " From Server.");
                            int n2 = 0;
                            while (n2 < stringArray.length) {
                                this.sp.print(String.valueOf(stringArray[n2]) + "...");
                                if (!this.cl.getFile(n, stringArray[n2])) {
                                    this.sp.println("ERROR");
                                    break;
                                }
                                this.sp.println("OK");
                                this.cl.delFile(n, stringArray[n2]);
                                ++n2;
                            }
                            this.cl.Stop(n);
                            this.cl.stop();
                            this.cl = null;
                            return;
                        }
                        this.sp.println("No Such File(s) found. Server stoped.");
                        this.cl.Stop(n);
                        this.cl.stop();
                        return;
                    }
                    this.sp.println("Invalid ServerID number, Server stop");
                    this.cl.Stop(n);
                    this.cl.stop();
                    return;
                }
                this.sp.println("The Server as reached the maximum number of allowed clients.\nConnection to Server rufused.");
                this.cl.stop();
                return;
            }
            this.sp.println("Unable to Connect to Server...");
            return;
        }
        catch (RemoteException remoteException) {
            String[] stringArray = new String[]{"A Remote Exception occured", remoteException.toString()};
            this.m.errPrint(stringArray, "Remote Exception");
            return;
        }
    }
}

