/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.rmi.RemoteException;

public class MopacApp
extends Thread {
    private String[] Jobs;
    private String[] Jobs2;
    private Process process;
    private MopacPanel mp;
    private String command;
    private String Mode;
    private String[] com;
    private Timer tm1;
    private Timer tm2;
    private ChemConsoleClient cl;
    private int id;
    private StatusPanel sp;
    private boolean sstate;

    public MopacApp(MopacPanel mopacPanel) {
        this.mp = mopacPanel;
        this.command = mopacPanel.getCommand();
        this.Mode = mopacPanel.getMode();
        this.Jobs = mopacPanel.getJobs();
    }

    public void run() {
        this.startJob();
    }

    private void startJob() {
        if (this.Mode.equals("local")) {
            this.tm1 = new Timer();
            this.mp.setActive(false);
            this.com = new String[2];
            this.com[0] = this.command;
            this.tm1.start();
            int n = 0;
            while (n < this.Jobs.length) {
                this.com[1] = this.Jobs[n];
                this.tm2 = new Timer();
                try {
                    this.process = Runtime.getRuntime().exec(this.com);
                    this.tm2.start();
                    this.process.waitFor();
                    this.tm2.stop();
                }
                catch (IOException iOException) {
                    System.out.println("Mopac Error : " + iOException);
                    this.stop();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Mopac Error : " + interruptedException);
                    this.stop();
                }
                ++n;
            }
            this.tm1.stop();
            this.mp.setActive(true);
            this.process = null;
            return;
        }
        if (this.Mode.equals("network")) {
            this.sp = new StatusPanel("Mopac Server(" + this.mp.getServer() + ") Status");
            this.sp.println("Contacting Mopac Server...");
            try {
                this.cl = new ChemConsoleClient("mopac", this.mp.getServer());
                this.cl.setDaemon(true);
                this.cl.start();
                if (this.cl.server != null) {
                    this.id = this.cl.startAppServer();
                    if (this.id != -1) {
                        if (this.cl.isActive(this.id)) {
                            this.sstate = true;
                            this.sp.println("Connected to Mopac Server(" + this.id + ")...");
                            this.sp.println("\nTransferring Data file(s) to Server.");
                            int n = 0;
                            while (n < this.Jobs.length) {
                                if (!this.cl.putFile(this.id, this.Jobs[n], this.Jobs[n])) {
                                    this.sp.println("An Error occured whileTransferring " + this.Jobs[n] + " to the " + "Server.");
                                    this.cl.Stop(this.id);
                                    this.stop();
                                }
                                this.sp.println("Transferred " + this.Jobs[n]);
                                ++n;
                            }
                            if (this.mp.isRetrieve()) {
                                this.sp.println("\nStarting Mopac on Server.");
                                if (this.cl.runApp(this.id, this.Jobs)) {
                                    this.sp.println("Retrieving the Mopac output files");
                                    int n2 = 0;
                                    while (n2 < this.Jobs.length) {
                                        String string = null;
                                        int n3 = this.Jobs[n2].length() - 4;
                                        String string2 = this.Jobs[n2].substring(0, n3);
                                        String[] stringArray = this.cl.getFileList(this.id, string2, string);
                                        if (stringArray != null) {
                                            int n4 = 0;
                                            while (n4 < stringArray.length) {
                                                this.cl.getFile(this.id, stringArray[n4]);
                                                this.sp.println("Recieved " + stringArray[n4]);
                                                ++n4;
                                            }
                                        }
                                        this.sp.println("\nDone...");
                                        ++n2;
                                    }
                                }
                                this.cl.Stop(this.id);
                                this.sstate = false;
                                return;
                            }
                            this.cl.setRetrieve(this.id, false);
                            this.sp.println("\nStarting Mopac on the Server.");
                            this.cl.runApp(this.id, this.Jobs);
                            this.sp.println("\nOutput files will be left on Server");
                            this.sp.println("Done..");
                            this.sstate = false;
                            return;
                        }
                        this.sstate = false;
                        this.sp.println("Mopac Services are not provided by this Server");
                        this.cl.Stop(this.id);
                        this.stop();
                        return;
                    }
                    this.sstate = false;
                    this.sp.println("The Mopac Server has reached the maximum number of allowed clients.\nTry Back later.");
                    this.stop();
                    return;
                }
                this.sstate = false;
                this.sp.println("Connnection to the Server refused");
                this.stop();
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException.toString());
                return;
            }
        }
    }

    public void stopJob() {
        if (this.Mode.equals("local")) {
            this.process.destroy();
            return;
        }
        if (this.Mode.equals("network") && this.sstate) {
            try {
                this.cl.StopJob(this.id);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }

    public void stopAllJobs() {
        if (this.Mode.equals("local")) {
            this.stopJob();
            this.stop();
            return;
        }
        if (this.Mode.equals("network")) {
            if (this.sstate) {
                try {
                    this.cl.StopJob(this.id);
                    this.cl.Stop(this.id);
                }
                catch (RemoteException remoteException) {}
            }
            this.stop();
        }
    }

    public String[] getStatus() {
        String[] stringArray = new String[1];
        if (this.Mode.equals("local")) {
            if (this.process != null) {
                int[] nArray = this.tm1.getMinSec();
                int[] nArray2 = this.tm2.getMinSec();
                String string = String.valueOf(nArray[0]) + "." + nArray[1] + " Min";
                String string2 = String.valueOf(nArray2[0]) + "." + nArray2[1] + " Min";
                String[] stringArray2 = new String[]{"The Current Job is " + this.com[1], "It has been runing for " + string2, "The Total time  is " + string};
                return stringArray2;
            }
            String[] stringArray3 = new String[]{"There are no Mopac Jobs Runing"};
            return stringArray3;
        }
        if (this.Mode.equals("network")) {
            if (this.sstate) {
                try {
                    return this.cl.getStatus(this.id);
                }
                catch (RemoteException remoteException) {
                }
            } else {
                String[] stringArray4 = new String[]{"Mopac Server is not runing", "or Output files are being left on the Server"};
                return stringArray4;
            }
        }
        return stringArray;
    }
}

