/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.TitledBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class MopacConfigPanel
extends JPanel
implements ActionListener {
    private String APP_BIN = "mopac";
    private boolean REM_EXT = true;
    private Vector ServerList;
    private ServerConfigPanel Sp;
    private ChemMessage m = new ChemMessage(this);
    private static File cfile = new File("Config/mopac.cfg");
    private JTextField tf1;
    private JButton bt1;
    private JButton bt2;
    private AbstractButton ab1;

    public MopacConfigPanel() {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.ServerList = new Vector();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        TitledBorder titledBorder = new TitledBorder("Mopac Properties");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(1);
        jPanel.setBorder((Border)titledBorder);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        JLabel jLabel = new JLabel("Mopac File : ");
        jPanel2.add((Component)jLabel);
        this.tf1 = new JTextField(20);
        jPanel2.add((Component)this.tf1);
        this.bt1 = new JButton("Browse");
        this.bt1.addActionListener((ActionListener)this);
        jPanel2.add((Component)this.bt1);
        jPanel.add((Component)jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        this.ab1 = new JCheckBox("Remove Ext");
        this.ab1.addActionListener((ActionListener)this);
        jPanel3.add((Component)this.ab1);
        jPanel.add((Component)jPanel3);
        ((Container)((Object)this)).add((Component)jPanel, "North");
        this.Sp = new ServerConfigPanel();
        titledBorder = new TitledBorder("Mopac Server(s)");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(1);
        this.Sp.setBorder((Border)titledBorder);
        ((Container)((Object)this)).add((Component)((Object)this.Sp), "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout());
        this.bt2 = new JButton("Save");
        this.bt2.addActionListener((ActionListener)this);
        jPanel4.add((Component)this.bt2);
        ((Container)((Object)this)).add((Component)jPanel4, "South");
        this.ReadCfg();
        this.upDate();
    }

    private void ReadCfg() {
        if (cfile.isFile()) {
            TextInputFile textInputFile = new TextInputFile(cfile);
            this.APP_BIN = textInputFile.readString();
            this.REM_EXT = textInputFile.readBoolean();
            while (!textInputFile.eof()) {
                this.ServerList.addElement(textInputFile.readString());
            }
            textInputFile.close();
            return;
        }
        this.SaveCfg();
    }

    private void SaveCfg() {
        Enumeration enumeration = this.ServerList.elements();
        TextOutputFile textOutputFile = new TextOutputFile(cfile);
        textOutputFile.println(this.APP_BIN);
        textOutputFile.println(this.REM_EXT);
        while (enumeration.hasMoreElements()) {
            textOutputFile.println((String)enumeration.nextElement());
        }
        textOutputFile.close();
    }

    private void upDate() {
        this.tf1.setText(this.APP_BIN);
        this.ab1.setSelected(this.REM_EXT);
        this.Sp.setServer(this.ServerList);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bt1) {
            this.getMopac();
            return;
        }
        if (actionEvent.getSource() == this.ab1) {
            this.REM_EXT = this.ab1.isSelected();
            return;
        }
        if (actionEvent.getSource() == this.bt2) {
            this.SaveCfg();
        }
    }

    private void getMopac() {
        fDialog fDialog2 = new fDialog((Component)((Object)this), "Mopac File");
        fDialog2.setBackground(this.getPanelColor());
        fDialog2.show();
        String string = fDialog2.getDirectory();
        String string2 = fDialog2.getFile();
        if (string2 != null) {
            File file = new File(String.valueOf(string) + string2);
            if (file.isFile()) {
                this.APP_BIN = String.valueOf(string) + string2;
                this.tf1.setText(this.APP_BIN);
                return;
            }
            this.m.errPrint("The file " + string2 + " doesn't exist", "File Error");
        }
    }

    private Color getPanelColor() {
        return ((Component)((Object)this)).getBackground();
    }
}

