/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.border.BevelBorder;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.TitledBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;

public class ServerStatPanel
extends JPanel
implements ActionListener,
ItemListener {
    private int N_COLS = 60;
    private int N_ROWS = 15;
    private String title = "Server Status";
    private String host;
    private JTextArea textArea;
    private JTextField tf1;
    private JComboBox slb;
    private ChemDialog cd;
    private ChemMessage m;
    private ChemConsoleClient cl;

    public ServerStatPanel() {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.textArea = new JTextArea(this.N_ROWS, this.N_COLS);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane((Component)this.textArea);
        BevelBorder bevelBorder = new BevelBorder(1);
        jScrollPane.setBorder((Border)bevelBorder);
        ((Container)((Object)this)).add((Component)jScrollPane, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 15, 5));
        TitledBorder titledBorder = new TitledBorder("Server Selector");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(2);
        jPanel.setBorder((Border)titledBorder);
        serverList serverList2 = new serverList();
        this.slb = new JComboBox((Object[])serverList2.getServers());
        this.slb.addItemListener((ItemListener)this);
        jPanel.add((Component)this.slb);
        JLabel jLabel = new JLabel("name  : ");
        jPanel.add((Component)jLabel);
        this.tf1 = new JTextField(20);
        jPanel.add((Component)this.tf1);
        ((Container)((Object)this)).add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 15, 5));
        JButton jButton = new JButton("  OK  ");
        jButton.addActionListener((ActionListener)this);
        jButton.setActionCommand("ok");
        jPanel2.add((Component)jButton);
        jButton = new JButton("Cancel ");
        jButton.addActionListener((ActionListener)this);
        jButton.setActionCommand("cancel");
        jPanel2.add((Component)jButton);
        ((Container)((Object)this)).add((Component)jPanel2, "South");
        this.cd = new ChemDialog(this.title, this);
    }

    private void print(String string) {
        this.textArea.append(string);
    }

    private void println(String string) {
        this.print(String.valueOf(string) + "\n");
    }

    private void clear() {
        this.textArea.setText("");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            this.getInput();
            return;
        }
        if (string.equals("cancel")) {
            this.cd.close();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.slb) {
            Object object = this.slb.getSelectedItem();
            this.tf1.setText(object.toString());
        }
    }

    private void getInput() {
        this.host = this.tf1.getText();
        if (this.host.length() != 0) {
            this.getStats();
            return;
        }
        String[] stringArray = new String[]{"No Server Name Given.", "Please enter a server name now."};
        this.m = new ChemMessage(this);
        this.m.errPrint(stringArray, "Server Status Error");
    }

    private void getStats() {
        this.m = new ChemMessage(this);
        this.println("Contacting ChemConsole Server at " + this.host + "...");
        try {
            this.cl = new ChemConsoleClient("utility", this.host);
            if (this.cl.server != null) {
                int n = this.cl.startUtilityServer();
                if (n != -1) {
                    this.println("Connected to the ChemConsole Server...\n");
                    String[] stringArray = this.cl.getServerStats(n);
                    this.cl.Stop(n);
                    this.cl.stop();
                    this.cl = null;
                    this.printStats(stringArray);
                    return;
                }
                this.println("Connection refused. The maximum  number of allowed clients has been reached");
                return;
            }
        }
        catch (RemoteException remoteException) {
            String[] stringArray = new String[]{"A RemoteException Error ocurred.", remoteException.toString()};
            this.m.errPrint(stringArray, " RemoteException");
        }
    }

    private void printStats(String[] stringArray) {
        this.println("Here are the Stats for " + this.host + "...\n");
        this.println("The maximum number of Application Server clients allowed  : " + stringArray[0]);
        this.println("The maximum number of Utility Server clients allowed : " + stringArray[1]);
        this.println("The number Application Server clients currently connected : " + stringArray[2]);
        this.println("\nServer\t\t# of client(s)\t\t\tActive");
        this.println("======\t\t==============\t\t======");
        this.println("\nBabel\t\t" + stringArray[3] + "\t\t\t" + stringArray[4]);
        this.println("Mopac\t\t" + stringArray[5] + "\t\t\t" + stringArray[6]);
        this.println("Gaussian\t\t" + stringArray[7] + "\t\t\t" + stringArray[8]);
        this.println("Utility\t\t" + stringArray[9] + "\t\t\tN/A");
        this.println("");
    }
}

