
/**
 * BabelApp.java
 * This acts as the main interface between the ChemConsole GUI and the legacy 
 * Babel v 1.6 application
 * Created: Fri Apr 23 18:58:51 1999
 *
 * @author Nathan Stevens
 * @version 0.4 July-99
 */

import java.io.*;
import java.util.*;
import java.rmi.*;

public class BabelApp extends Thread 
{ 
  private String[] Command;   // The command passed the runApp method uses
  public String Mode;         // The mode local or network               
  public String BABEL_BIN;    // The Babel binary name
  private int intype;         // The input type converted to an interger
  public String inputType;    // The input type String string format 
  public String infile;       // The input full name of input file
  public String infile2;      // Just the name of input file
  public String keyw1;        // The input keyword
  private int outtype;        // The output file in integer format
  public String outputType;   // The output type in String format
  public String outfile;      // The name of output file
  public String keyw2;        // The output key word
  public String rnum;         // The renumber variable
  public String adh;          // The add/delete hydrogen variable           
  private String itype, otype;  // The input put out put Strings
  private Process process;      // The babel application process 
  private ChemConsoleClient cl; // The ChemConsoleClient object
  public String hostname;       // The hostname of babel server 
  private int id;               // The number id assigned by the Babel Server
  private StatusPanel sp;       // The network status Panel
  public boolean isRetrieve;    // See wheather to get files from the server
  private ChemMessage m = new ChemMessage();
  public boolean alert;          // This is to determine weather to notify the
                                 // calling class wheather to display a done 
                                 // message.
 
  BabelApp()
    { 
      // default constructor
      this(true);
    }

  BabelApp(boolean b)
    {
      alert = b;
    }

  //The run method
  public void run()
    {  
      // Convert the intype an out type String to intergers
      try
	{
          intype = Integer.parseInt(inputType);
          outtype = Integer.parseInt(outputType);
	}

      catch(NumberFormatException e)
	{
          String[] emsg = {"Unable to Convert Input or Output entry",
                           "to an Integer. Please check values. "};
          m.errPrint(emsg, "NumberFormat Error");
          this.stop();
	}  
      checkfile();       
    }

   private void checkfile()
    {
      //System.out.println("check file called");    debug code

      // first thing we do is check to see if the input file really exist
      File inputfile = new File(infile);
      String[] emsg = {"The input file " + infile + " doesn't exist.",
                       "Please check that the correct inputfile name  was",
                       "entered..."};
 
      if(inputfile.isFile())
	{
          setCommand();            // this method set the command
	}
      else
	{
          m.errPrint(emsg, "File Error");
          this.stop();
	}
    }

  // method that set the command String according to the variables that were 
  // passed to the  constructor
  private void setCommand()
    { 
      itype = "-i" + getInputType();
      otype = "-o" + getOutputType();

      /*now we make a String of the commmand. the format is:
       babel  -i<itype> <infile> [keywords] -o<out type> <outfile> [keywords2]
      */
      
      Vector commandv = new Vector();
  
      //seed the vector with required arguments
      if(Mode.equals("local"))
	{
          commandv.addElement(BABEL_BIN);
          commandv.addElement(itype);
          commandv.addElement(infile);
          commandv.addElement(otype);
          commandv.addElement(outfile);
	}
      else if(Mode.equals("network")) 
	{
          sp = new StatusPanel("Babel Server("+ hostname +") Status");
          sp.println("Contacting Babel Server...");

          try
	    {
               cl = new ChemConsoleClient("babel", hostname);
               cl.setDaemon(true);
               cl.start();
        
               if(cl.server != null)
		 {
                   id = cl.startAppServer();

                   if(id != -1)
		     {
                       if(cl.isActive(id))
		         {
			   // Get the status of the server
                           sp.println("Connected to Babel Server("+id+ ")...");

                           String wdir = cl.getWorkDir(id) + "/";      
        
                           commandv.addElement(cl.getAppBin(id));
                           commandv.addElement(itype);
                           commandv.addElement(wdir + infile2);
                           commandv.addElement(otype);
                           commandv.addElement(wdir + outfile);
      		         }
                       else
		         {
		           sp.println("Babel Services are not provided " + 
                                      "by this Server");
                           cl.Stop(id);
                           this.stop();
			 }
		     }
                   else
		    {
		      sp.println("The Babel Server has reached the maximum " +
                                 "number of allowed clients." +
                                 "\nTry Back later.");
                      this.stop();
		    }
	         }
               else
		 {
                   sp.println("Connnection to Server refused");
                   this.stop();
		 }
	    }
          catch(RemoteException re)
	    {
              m.errPrint(re.toString(), "Remote Exception");
              this.stop();
	    }            
	}

      // Now add the rest of supplemental arguments
      if(keyw2 != null)
        commandv.addElement(keyw2);
      if(rnum != null)
        commandv.insertElementAt(rnum, 3);
      if(adh != null)
        commandv.insertElementAt(adh, 3);
      if(keyw1 != null)
        commandv.insertElementAt(keyw1, 3);

      // now copy the vector into an array of type String
      Command = new String[commandv.size()];
      commandv.copyInto(Command);
       
      runApp();
    }
  
  // Method to return the type of inpute
  private String getInputType()
    {
      switch(intype)
	{
	case 1:
          return "alc";
	case 2:
          return "prep";
	case 3:
          return "bs";
	case 4:
          return "bgf";
	case 5:
          return "car";
	case 6:
          return "boog";
	case 7:
          return "caccrt";
	case 8:
          return "cadpac";
	case 9:
          return "charmm";
	case 10:
          return "c3d1";
	case 11:
          return "c3d2";
	case 12:
          return "cssr";
	case 13:
          return "fdat";
	case 14:
          return "gstat";
	case 15:
          return "dock";
	case 16:
          return "dpdb";
	case 17:
          return "feat";
	case 18:
          return "fract";
	case 19:
          return "gamout";
	case 20:
          return "gzmat";
	case 21:
          return "guout";
	case 22:
          return "g94";
	case 23:
          return "gr96A";
	case 24:
          return "gr96N";
	case 25:
          return "hin";
	case 26:
          return "sdf";
	case 27:
          return "m3d";
	case 28:
          return "macmol";
	case 29:
          return "macmod";
	case 30:
          return "mocro";
	case 31:
          return "mm2in";
	case 32:
          return "mm2out";
	case 33:
          return "mm3";
	case 34:
          return "mmads";
	case 35:
          return "mdl";
	case 36:
          return "molen";
	case 37:
          return "mopcrt";
	case 38:
          return "mopint";
	case 39:
          return "mopout";
	case 40:
          return "pcmod";
	case 41:
          return "pdb";
	case 42:
          return "psin";
	case 43:
          return "psout";
	case 44:
          return "msf";
	case 45:
          return "schakal";
	case 46:
          return "shelx";
	case 47:
          return "smiles";
	case 48:
          return "spar";
	case 49:
          return "semi";
	case 50:
          return "spmm";
	case 51:
          return "mol";
	case 52:
          return "mol2";
	case 53:
          return "wiz";
	case 54:
          return "unixyz";
	case 55:
          return "xyz";
	case 56:
          return "xed";
        default:
	  {
            String[] emsg = {"This is not a supported input type"};
            m.errPrint(emsg, "Input Type Error");
	  }
	}
     this.stop();             // prevent any other method from executing
     
     //we never get to this point
     return "xxx";
    } 

  // Method to return type of output
  private String getOutputType()
    {
      switch(outtype)
	{
	  case 1:
           return "diag";
	  case 2:
           return "alc";
	  case 3:
           return "bs";
	  case 4:
           return "bgf";
	  case 5:
           return "bmin";
	  case 6:
           return "box";
	  case 7:
           return "caccrt";
	  case 8:
           return "cacint";
	  case 9:
           return "cache";
	  case 10:
           return "c3d1";
	  case 11:
           return "c3d2";
	  case 12:
           return "cdct";
	  case 13:
           return "dock";
	  case 14:
           return "wiz";
	  case 15:
           return "contmp";
	  case 16:
           return "cssr";
	  case 17:
           return "dpdb";
	  case 18:
           return "feat";
	  case 19:
           return "fhz";
	  case 20:
           return "gamin";
	  case 21:
           return "gcart";
	  case 22:
           return "gzmart";
	  case 23:
           return "gotmp";
	  case 24:
           return "gr96A";
	  case 25:
           return "gr96N";
	  case 26:
           return "hin";
	  case 27:
           return "icon";
	  case 28:
           return "idatm";
	  case 29:
           return "sdf";
	  case 30:
           return "m3d";
	  case 31:
           return "macmol";
	  case 32:
           return "macmod";
	  case 33:
           return "micro";
	  case 34:
           return "mm2in";
	  case 35:
           return "mm2out";
	  case 36:
           return "mm3";
	  case 37:
           return "mmads";
	  case 38:
           return "mdl";
	  case 39:
           return "miv";
	  case 40:
           return "mopcrt";
	  case 41:
           return "mopint";
	  case 42:
           return "csr";
	  case 43:
          return "pcmod";
	  case 44:
          return "pdb";
	  case 45:
          return "psz";
	  case 46:
          return "psc";
	  case 47:
          return "report";
	  case 48:
          return "smiles";
	  case 49:
          return "spar";
	  case 50:
          return "mol";
	  case 51:
          return "mol2";
	  case 52:
          return "maccs";
	  case 53:
          return "torlist";
	  case 54:
          return "tinker";
	  case 55:
          return "unixyz";
	  case 56:
          return "xyz";
	  case 57:
          return "xed";
	default:
	  {
            String[] emsg  = {"This is not a supported output type"};
            m.errPrint(emsg, "Output Type Error");
	  }
	}
      
      this.stop();           //prevent any other thing from executing
      //we never get to this point
      return "xxx";
    }
  
  // Method that runs the native babel app. it will check the mode of the babel
  // panel to see weather it is runing in local or native mode;

  private void runApp()
    {
      if(Mode.equals("local"))
	{
         try
	   {  
             /*debug code
             for(int i = 0; i < Command.length; i++)
               System.out.println(Command[i] + "  " + Command.length)*/;
                            
             process = Runtime.getRuntime().exec(Command);
             process.waitFor();

	     //check to see if file was created and notify when done
             if(alert)
	       {
                 m.msgPrint("Babel Conversion of " + infile + " completed", "Bable Status");
	       }
	   }    
         catch(IOException e)
           {
	     m.errPrint(e.toString(), "IOExcetion");
             this.stop();
           }
         catch(Exception e)
	   { 	     
             // Stop the thread
             m.errPrint(e.toString(), "BabelApp Thread Exception");
             this.stop();        
	   }
	}

      else if(Mode.equals("network"))
	{
          try
	    {
	      //copy the input file to the server
              sp.println("Sending input file, " +
                         infile2 + " ,to Server.");
              if(cl.putFile(id, infile, infile2))
		 {
                   sp.println("Executing Babel");

                   if(cl.runApp(id, Command))
		     {
                       if(isRetrieve)
			 {
                           sp.println("Retrieving the output file, "+ 
                                          outfile + " ,from Server.");
                           cl.getFile(id, outfile);
                       
		           // now kill the thread on the server
                           cl.Stop(id);
                           this.stop();
			 }
                       else
			 {
                           sp.println("The Output file(s) will be left on the server.");
                           cl.Stop(id);
                           this.stop();
			 }
		     }
                   else
		     {
                       sp.println("Babel failed to execute");
                       cl.Stop(id);
                       this.stop();
		     }
		 }
               else
		 {
                   sp.println("Can't send input file");
                   cl.Stop(id);
                   this.stop();
		 }
	    }
         catch(RemoteException re)
	   {
             sp.println("Server Error : " + re);
             this.stop();
	   }
	}
    }
}
     
   















