
/**
 * ChemConsoleFrame.java
 * This is the main frame class in the Chemconsole program
 *
 * Created: Thu Apr 22 10:01:48 1999
 *
 * @author Nathan Stevens
 * @version 0.4  July 99
 */

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
//import javax.swing.*;
//import javax.swing.event.*;
 
public class ChemConsoleFrame extends JFrame implements ActionListener
{  
  private ChemMessage m = new ChemMessage();
  private ChemDialog cd;
  
  public ChemConsoleFrame (String title)
    {
      super(title);            // call the base constructor
   
      // Construct the menu bar
      JMenuBar mbar = new JMenuBar();
       
      JMenu menu;
      JMenu net;
      JMenuItem item;
     
      // The File menu
      menu = new JMenu("File");
      menu.setMnemonic('F');

      item = new JMenuItem("Exit");
      item.addActionListener(this);
      item.setActionCommand("exit");
      item.setMnemonic('e'); 
      menu.add(item);
      mbar.add(menu);
     
      // The Configure menu
      menu = new JMenu("Edit");
      menu.setMnemonic('E');
       
      item = new JMenuItem("Local Config");
      item.addActionListener(this);
      item.setActionCommand("lc");
      item.setMnemonic('l');
      menu.add(item);
      
      menu.addSeparator();
     
      item = new JMenuItem("Server Config");
      item.addActionListener(this);
      item.setActionCommand("sc");
      item.setMnemonic('s');
      menu.add(item);      

      mbar.add(menu);
      
      //The tool menu 
      menu  = new JMenu("Tools");
      menu.setMnemonic('T'); 
     
      item = new JMenuItem("BABEL");
      item.addActionListener(this);
      item.setActionCommand("babel");
      item.setMnemonic('b'); 
      menu.add(item);
     
      item = new JMenuItem("MOPAC");
      item.addActionListener(this);
      item.setActionCommand("mopac");
      item.setMnemonic('m');  
      menu.add(item);
     
      item = new JMenuItem("Guassian");
      item.addActionListener(this);
      item.setActionCommand("guassian");
      item.setMnemonic('g');
      menu.add(item);
    
      menu.addSeparator();
      
      net = new JMenu("NetWork");            // Network apps section
      net.setMnemonic('N'); 
 
      item = new JMenuItem("BABEL");          // code will write a method
      item.addActionListener(this);
      item.setActionCommand("nbabel");
      item.setMnemonic('a');
      net.add(item);
      
      item = new JMenuItem("MOPAC");
      item.addActionListener(this);
      item.setActionCommand("nmopac");
      item.setMnemonic('o');
      net.add(item);

      item = new JMenuItem("Gaussian");
      item.addActionListener(this);
      item.setActionCommand("ngaussian");
      item.setMnemonic('g');
      net.add(item);
      menu.add(net);
            
      mbar.add(menu);

      // The Utilities menu
      menu = new JMenu("Utilities");
      menu.setMnemonic('U'); 

      item = new JMenuItem("fileViewer");
      item.addActionListener(this);
      item.setActionCommand("fv");
      item.setMnemonic('v');
      menu.add(item);
      
      menu.addSeparator();
      
      net = new JMenu("Network");
      net.setMnemonic('N'); 

      item = new JMenuItem("fileGetter");
      item.addActionListener(this);
      item.setActionCommand("fg");
      item.setMnemonic('g');
      net.add(item);
  
      item = new JMenuItem("Server Stats");
      item.addActionListener(this);
      item.setActionCommand("ss");
      item.setMnemonic('s');
      net.add(item);
      
      menu.add(net);      
     
      mbar.add(menu);
   
      mbar.add(Box.createHorizontalGlue());
        
      // The Help menu
      menu  = new JMenu("Help");
      menu.setMnemonic('H'); 
      
      item = new JMenuItem("Contents");
      item.addActionListener(this);
      item.setActionCommand("content");
      item.setMnemonic('c');
      menu.add(item);
      
      menu.addSeparator();

      item = new JMenuItem("About");
      item.addActionListener(this);
      item.setActionCommand("about");
      item.setMnemonic('a');
      menu.add(item);

      mbar.add(menu);
      
      // set the menu bar
      setJMenuBar(mbar);  
     
    }
          
  public void actionPerformed(ActionEvent e)
    {
      String cmd = e.getActionCommand();
      
      if(cmd.equals("exit"))
      {
        close();
      }
      else if(cmd.equals("babel"))
	{
          BabelPanel bp = new BabelPanel();
          cd = new ChemDialog("Babel Tool", bp);
	}     
      else if(cmd.equals("mopac"))
	{
          MopacPanel mp  = new MopacPanel();
          cd = new ChemDialog("Mopac Tool", mp);
	}
      else if(cmd.equals("guassian"))
	{
	  //code
	}
      else if(cmd.equals("lc"))
	{
          ConfigPanel cfg = new ConfigPanel();
	}
      else if(cmd.equals("sc"))
	{
          // code
	}
      else if(cmd.equals("nbabel"))
	{
          BabelPanel nbp = new BabelPanel("network");
          cd = new ChemDialog("Network Babel Tool", nbp);
	}
      else if(cmd.equals("nmopac"))
	{
          MopacPanel nmp  = new MopacPanel("network");
          cd = new ChemDialog("Network Mopac Tool", nmp);
	}
      else if(cmd.equals("fv"))
	{
          DataFileEditorPanel dfe = new DataFileEditorPanel("File Viewer");
          dfe.setEditable(false);
	}
      
      else if(cmd.equals("fg")) {
          FileGetterPanel fgp = new FileGetterPanel();
      }

      else if(cmd.equals("ss")) {
          ServerStatPanel stp = new ServerStatPanel();
      }          
       
      else if(cmd.equals("content"))
	{
          Help hp = new Help();
	}
      else if(cmd.equals("about"))
	{
          getAbout();
	}      
    }

  // Method to print the about message
    private void getAbout() {
	//
        String[] msg = {"ChemConsole v-0.4",
                        " ",
                        "Author: Nathan Stevens",
                        "Email : nat250@cyberwar.com",
                        " ",
                        "Sends Bugs to above email"};

       m.msgPrint(msg, "About");
    }
   
    // method to close the exit the program
    private void close() {
	//
        setVisible(false);
        dispose();
        System.exit(0);
    }
} 
         
 



