
/**
 * ConfigPanel.java 
 * This is the main Config panel for the Chemconsole program. all the other
 * Config panel is loaded into this one. 
 * Created: Sat May  1 19:05:48 1999
 *
 * @author Nathan Stevens
 * @version 0.4 July-99 
 */
import java.awt.*;
import java.io.*;
import java.util.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.text.*;
//import javax.swing.*;
//import javax.swing.border.*;
//import javax.swing.text.*;

public class ConfigPanel extends JPanel implements ActionListener,
    ItemListener {

    private String DEFAULT_APP = "babel";
    private String DEFAULT_MODE = "local";
    private static File CONFIG_FILE = new File("Config/main.cfg"); 
    private AbstractButton rd1, rd2, rd3, rd1b, rd2b;
    private JPanel mainp;
    private JButton bt1, bt2;
    private JTextField tf1;
    private JComboBox bBox; 
    private TextInputFile Infile;
    private TextOutputFile Outfile;
    private String BROWSER;
    private Vector browsers;
    private int bc;                                    // browser choice
    private ChemDialog cd; 

    //main constructor
    public ConfigPanel() { 

	//Read in the Config file
        ReadCfg();

        //Create the main tabs
        JTabbedPane tPane = new JTabbedPane();
            
        /**
	 * Add the main config panel to pane with GridbagLayout
	 **/
    
        mainp = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints ct = new GridBagConstraints();
        mainp.setLayout(layout);
                
	/**
	 * Add the the first panel that has the radio buttons
	 **/
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(FlowLayout.LEFT, 30, 5));

        // Add the radio buttons
        ButtonGroup group = new ButtonGroup();
     
        rd1 = new JRadioButton("Babel");
        rd1.addActionListener(this);
        group.add(rd1);
        p1.add(rd1);
     
        rd2 = new JRadioButton("Mopac");
        rd2.addActionListener(this);
        group.add(rd2);
        p1.add(rd2);  

        rd3 = new JRadioButton("Gaussian");
        rd3.addActionListener(this);
        group.add(rd3);
        p1.add(rd3);

	// set the constraints
        ct.weightx = ct.weighty = 10.0;
        ct.fill = ct.BOTH;
       
        addPanel("Default Tool", p1, ct, layout);
      
        /**
	 * Add the local or network mode selector panel
	 **/

        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(FlowLayout.LEFT, 30, 5));

        // Add the  radio buttons
        ButtonGroup group2 = new ButtonGroup();
     
        rd1b = new JRadioButton("Local");
        rd1b.addActionListener(this);
        group2.add(rd1b);
        p2.add(rd1b);
     
        rd2b = new JRadioButton("Network");
        rd2b.addActionListener(this);
        group2.add(rd2b);
        p2.add(rd2b); 
 
	// now set constraints
        ct.insets = new Insets(0,0,0,0);
        ct.gridx = 0;
        ct.gridwidth = 1;

        addPanel("Deafault Tool Mode", p2, ct, layout);

	/**
	 * Add the third panel that holds browser config
	 **/
        JPanel p3 = new JPanel();
        p3.setLayout(new FlowLayout(FlowLayout.LEFT ,10 , 5));

        bBox = new JComboBox(getBrowsers());
        bBox.setEditable(false);
        bBox.addItemListener(this);
   
        p3.add(bBox);

        // Now add the JTextfield
        JLabel lb1 = new JLabel("Browser file : ");
        p3.add(lb1);
   
        tf1 = new JTextField(20);
        p3.add(tf1);

	// now set constraints
        ct.insets = new Insets(0,0,0,0);
        ct.gridx = 0;
        ct.gridwidth = 1;

        addPanel("Browser", p3, ct, layout);
            
        // Add the Save and cancel buttons
        JPanel p4 = new JPanel();
        p4.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 5)); 
      
        bt1 = new JButton(" Save ");
        bt1.addActionListener(this);
        p4.add(bt1);

        bt2 = new JButton("Cancel");
        bt2.addActionListener(this);
        p4.add(bt2);
        
        ct.insets = new Insets(0,0,0,0);
        ct.gridx = 0;
        ct.gridwidth = 1;

        addPanel(p4, ct, layout);                 
                                
        tPane.addTab("Main", mainp);
      
        upDate();  

        /**
         * Add the babel config panel and rest of panels
         **/

        BabelConfigPanel babelp = new BabelConfigPanel();
        tPane.addTab("Babel", babelp);
     
        //add the mopac config Panel
        MopacConfigPanel mopacp = new MopacConfigPanel();
        tPane.addTab("Mopac", mopacp);
   
        //add the gaussian config panel
        GaussConfigPanel gaussp = new GaussConfigPanel();
        tPane.addTab("Gaussian", gaussp);
       
        tPane.setSelectedIndex(0);

        add(tPane);

	// now add this to the ChemDialog, cd
        cd = new ChemDialog("Configure", this);            
    }
     
    // Method to read the config file
    private void ReadCfg() {
	if(CONFIG_FILE.isFile()) {

	    // this reads in the main config file "Config/main.cfg" if it exist
            Infile = new TextInputFile(CONFIG_FILE);
          
            // set the default modes and
            DEFAULT_APP = Infile.readString();
            DEFAULT_MODE = Infile.readString();
            BROWSER = Infile.readString();
          
	    // close the file
            Infile.close();
	}	      
    }

    // Method to set the update the main panel components with the stuff read
    // in from the config file
    private void upDate() {
	// now set the buttons appropriatly
        if(DEFAULT_APP.equals("babel"))
            rd1.setSelected(true);

        else if(DEFAULT_APP.equals("mopac"))    
            rd2.setSelected(true);

        else if(DEFAULT_APP.equals("gaussian"))	            
            rd3.setSelected(true);
    
        if(DEFAULT_MODE.equals("local"))
            rd1b.setSelected(true);
  
        else if(DEFAULT_MODE.equals("network"))
            rd2b.setSelected(true);
      	
        // Put the browser type in the text field
        tf1.setText(BROWSER);          
    }    
  
    //method to save config file
    private void SaveCfg() {
	
        Outfile = new TextOutputFile(CONFIG_FILE);
     
        Outfile.println(DEFAULT_APP);
        Outfile.println(DEFAULT_MODE);
        Outfile.println(BROWSER);
     
        Outfile.close();    
    }
  
    // Method to return a list of Browsers
    public Vector getBrowsers() {

      browsers = new Vector();
      browsers.addElement("Netscape");
      browsers.addElement("Opera");
      browsers.addElement("Gecko");
      browsers.addElement("HotJava");
      browsers.addElement("IExplorer");
      
      return  browsers;
    }

    // Method to add A JPanel to the main panel
    private void addPanel(String title, JPanel panel, GridBagConstraints ct, 
                          GridBagLayout layout) {
	// Add a border to panel
        TitledBorder border = new TitledBorder(title);
        border.setTitlePosition(TitledBorder.TOP);
        border.setTitleJustification(TitledBorder.LEFT);
        panel.setBorder(border);        
    
	// now add JPanel, panel, to main panel
        layout.setConstraints(panel, ct);
        mainp.add(panel);
    }

    // Method to add a panel to the main panel, mainp
    private void addPanel(JPanel panel, GridBagConstraints ct, 
                          GridBagLayout layout) {    
	// Add panel p to main panel
        layout.setConstraints(panel, ct);
        mainp.add(panel);
    }

    // Method to handel action events
    public void actionPerformed(ActionEvent e) {
	
        if(e.getSource() == rd1 && rd1.isSelected() == true)
	    DEFAULT_APP = "babel";
      
        else if(e.getSource() == rd2 && rd2.isSelected() == true)
            DEFAULT_APP = "mopac";
	
        else if(e.getSource() == rd3 && rd3.isSelected() == true)
            DEFAULT_APP = "gaussian";
	
        else if(e.getSource() == rd1b && rd1b.isSelected() == true)
            DEFAULT_MODE = "local";

        else if(e.getSource() == rd2b && rd2b.isSelected() == true)
            DEFAULT_MODE = "network";

        else if(e.getSource() == bt1) {
            BROWSER = tf1.getText();
            SaveCfg();
	} 
        else if(e.getSource() == bt2)
            cd.close();
    }

    // Method to handel events goes here
    public void itemStateChanged(ItemEvent ie) {
	if(ie.getSource() == bBox) {
	    bc = bBox.getSelectedIndex();
 
            switch(bc) {
	    case 0:
	        tf1.setText("netscape");
		break;
            case 1:
                tf1.setText("opera");
                break;
            case 2:
                tf1.setText("\"Soon I hope\"");
                break;
            case 3:
                tf1.setText("hotjava");
                break;
            case 4:
                tf1.setText("crap!!!");        // sorry! couldn't resist
                break;
	    }
	}
    }
}     






