
/**
 * Class Dedit is a class that allow the users so that 
 * They can edit the input files using the build in editor
 *@author Nathan Stevens
 *@version 0.4 July-99
 */

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import com.sun.java.swing.*;
import com.sun.java.swing.text.*; 
import com.sun.java.swing.border.*; 
//import javax.swing.*;
//import javax.swing.text.*;
//import javax.swing.border.*;

public class DataFileEditorPanel extends JPanel implements ActionListener
{
  private JTextArea textArea;      // The text area object
  private int N_ROW = 20;
  private int N_COL = 80;
  private String data;
  private Font f;
  private File file;
  private ChemDialog win;
  private ChemMessage m;
  private fDialog fd;
  private JButton bt1, bt2, bt3, bt4;

  // Constructors
  public DataFileEditorPanel()
    {
      this("Date File");
    }

  public DataFileEditorPanel(String title)
    {    
      // use a Border layout
      setLayout(new BorderLayout());
      setLocation(50, 70);

      // Construct the textArea
      f = new Font("Monospaced", Font.PLAIN, 12);
      
      textArea = new JTextArea("" ,N_ROW, N_COL);
      textArea.setEditable(true);
      textArea.setLineWrap(true);
      textArea.setWrapStyleWord(true);
      textArea.setFont(f);
      
      // Add it to the Frame
      JScrollPane areaScrollPane = new JScrollPane(textArea);
      areaScrollPane.setVerticalScrollBarPolicy(
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
      Border border;
      border = new BevelBorder(BevelBorder.LOWERED);
      areaScrollPane.setBorder(border);        

      add(areaScrollPane, "Center");
      
      // create a button panel and add the Panel to the frame
      JPanel bp  = new JPanel();
      FlowLayout ly = new FlowLayout(FlowLayout.CENTER, 50, 5);      
      bp.setLayout(ly);

      // set the border
      TitledBorder border2 = new TitledBorder("File");
      border2.setTitlePosition(TitledBorder.TOP);
      border2.setTitleJustification(TitledBorder.CENTER);
      bp.setBorder(border2); 

      // Create the button and add it to panel 

      bt1 = new JButton("Open");
      bt1.addActionListener(this);
      bt1.setActionCommand("open");
      bp.add(bt1);      
      
      bt2 = new JButton("Save");
      bt2.addActionListener(this);
      bt2.setActionCommand("save");
      bp.add(bt2);
     
      bt3 = new JButton("Clear");
      bt3.addActionListener(this);
      bt3.setActionCommand("clear");
      bp.add(bt3);
     
      bt4 = new JButton("Close");
      bt4.addActionListener(this);
      bt4.setActionCommand("close");
      bp.add(bt4);
     
      // Add the buttons to panel
      add(bp, "South");
      
      win = new ChemDialog(title, this);
    }
    
  // Handle the events
  public void actionPerformed(ActionEvent e)
    {
      String cmd;
      cmd = e.getActionCommand();
      
      if(cmd.equals("open"))
	{
          getFile();
	}
        
      else if (cmd.equals("save"))
	{
          saveText();
	}
      else if(cmd.equals("close"))
	{
          win.close();
	}
      else if(cmd.equals("clear"))
	{
          textArea.setText("");
	}
    }

  // Metohd to get a file from file dialog
  private void getFile()
    {
      // make a filedialog
      fd  = new fDialog(this, "Input File name");
      fd.setBackground(getPanelColor());
      fd.show();

      String fname = fd.getFile();
      String fdir = fd.getDirectory();

      // create file
      File tmpf = new File(fdir + fname);
      
      // call the setFile Method
      setFile(tmpf);
    }
  
  // Method to set the file to be displayed
  public void setFile(File infile)
    {
      if(infile.isFile())
	{
          this.file = infile;
          readText();
	}
      else
	{
          m = new ChemMessage(this);
          m.errPrint("Can't find file " + infile + ".", "File Error");
	}
    }

  // Method to set text area editable or not
  public void setEditable(boolean b)
    {
     textArea.setEditable(b);
     bt2.setEnabled(b);
     bt3.setEnabled(b);  
    }
  // Method to read text from file
  private void readText()
    {
      String dtext = "";
      TextInputFile f = new TextInputFile(file);
      while(!f.eof())
	{
          dtext += f.readLine() + "\n";
	}
      f.close();
      textArea.setText(dtext);
      // add code here
    }
  // Method to save the text from  display to a specific file
  private void saveText()
    {
      String dtext = textArea.getText();
      TextOutputFile f = new TextOutputFile(file);
      f.print(dtext);   
      f.close();   
    }

  //Method to get the color of the Panel
  private Color getPanelColor()
    {
      return getBackground();
    } 
}      

      
           



