
/**
 * FileGetterPanel.java
 * This class is the file getter panel, it provides a usr interface for  
 * getting files from the server.
 *
 * Created: Sat Jul  3 10:27:21 1999
 *
 * @author Nathan Stevens
 * @version 0.4 July-99
 */
import java.rmi.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.text.*;
//import javax.swing.*;
//import javax.swing.border.*;
//import javax.swing.text.*;

public class FileGetterPanel extends JPanel
    implements ActionListener, ItemListener {

    private StatusPanel sp;
    private ChemDialog cd;
    private ChemMessage m;
    private ChemConsoleClient cl;
    private JComboBox cb;
    private JTextField tf1, tf2, tf3;
    private JRadioButton rd1, rd2, rd3;
    private String jobType = null;
    private String name, serverID, host;
    private int sID;
    
    public FileGetterPanel() {
	// set the layout manager to gridbag layout
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints ct = new GridBagConstraints();
        setLayout(layout);

	/**
	 * Add the first panel that holds the radio buttons
	 **/
        ButtonGroup grp = new ButtonGroup();        
 
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(FlowLayout.CENTER, 15,5));

        rd1 = new JRadioButton("Babel");
        rd1.addActionListener(this);
        rd1.setActionCommand("babel");
        grp.add(rd1);
        
        p1.add(rd1);

        rd2 = new JRadioButton("Mopac");
        rd2.addActionListener(this);
        rd2.setActionCommand("mopac");
        grp.add(rd2);
        
        p1.add(rd2);

        rd3 = new JRadioButton("Gaussian");
        rd3.addActionListener(this);
        rd3.setActionCommand("gaussian");
        grp.add(rd3);
        
        p1.add(rd3);

	// now set the constriants
        ct.weightx = ct.weighty = 10.0;
        ct.fill = ct.HORIZONTAL;
       
        addPanel("Output File Type", p1, ct, layout);

	/**
	 * Add the second panel that hold the text field and name of file
	 **/
        JLabel lb;

        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(FlowLayout.LEFT, 5,5));
        
        lb = new JLabel("Name : ");
        p2.add(lb);

        tf1 = new JTextField(20);
        p2.add(tf1);
        
        lb = new JLabel("Server ID");
        p2.add(lb);
       
        tf2 = new JTextField(3);
        p2.add(tf2);
        
	// now set constraints
        ct.insets = new Insets(0,0,0,0);
        ct.gridx = 0;
        ct.gridwidth = 1;

        addPanel("File name", p2, ct, layout);

	/**
	 * Add the third panel that hold the JComboBox and text field
	 **/
   
        JPanel p3 = new JPanel();
        p3.setLayout(new FlowLayout(FlowLayout.LEFT, 5,5));

	// get the list of servers by using a severList object
        serverList serverlist = new serverList();                
        cb = new JComboBox(serverlist.getServers());
        cb.addItemListener(this);
        p3.add(cb);
              
        lb = new JLabel("name : ");
        p3.add(lb);
       
        tf3 = new JTextField(20);
        p3.add(tf3);

	// now set constraints
        ct.insets = new Insets(0,0,0,0);
        ct.gridx = 0;
        ct.gridwidth = 1;

        addPanel("Server", p3, ct, layout);

	/**
	 * Now add the OK and Cancel buttons
	 **/
        JButton bt;

        JPanel p4 = new JPanel();
        p4.setLayout(new FlowLayout(FlowLayout.CENTER, 15,5));
       
        bt = new JButton("  OK  ");
        bt.addActionListener(this);
        bt.setActionCommand("ok");
        p4.add(bt);        

        bt = new JButton("Cancel");
        bt.addActionListener(this);
        bt.setActionCommand("cancel");
        p4.add(bt);

	// now set constraints
        ct.insets = new Insets(0,0,0,0);
        ct.gridx = 0;
        ct.gridwidth = 1;

        addPanel(p4, ct, layout);
          
	// instantiate the ChemMessage object
        m = new ChemMessage(this);

	// Add this to the ChemDialog object
        cd = new ChemDialog("FileGetter", this);    
    }
    
    // Method to add the secondary panel to main Panel
    private void addPanel(String title, JPanel panel, GridBagConstraints ct, 
                          GridBagLayout layout) {
	// Add a border to panel
        TitledBorder border = new TitledBorder(title);
        border.setTitlePosition(TitledBorder.TOP);
        border.setTitleJustification(TitledBorder.LEFT);
        panel.setBorder(border);        
    
	// now add panel p to main panel
        layout.setConstraints(panel, ct);
        add(panel);
    }

    private void addPanel(JPanel panel, GridBagConstraints ct, 
                          GridBagLayout layout) {    
	// Add panel, panel, to main panel
        layout.setConstraints(panel, ct);
        add(panel);
    }

    // Actionlistener method
    public void actionPerformed(ActionEvent ae) {
	String cmd =  ae.getActionCommand();
	
        if(cmd.equals("ok")) {
	    // call the get file method
            getInput();
	}
        else if(cmd.equals("cancel")) {
	    // close the ChemDialog, cd
            cd.close();
	}   
        else if(cmd.equals("babel") && rd1.isSelected()) {
	    // set the jodtype to babel
            jobType = "babel";
	}
        else if(cmd.equals("mopac") && rd2.isSelected()) {
	    // set jobtype to mopac
            jobType = "mopac";
	}
        else if(cmd.equals("gaussian") && rd3.isSelected()) {
	    // set jobtype to gaussian
            jobType = "gaussian";
	}

    }
    
    // Item listener method
    public void itemStateChanged(ItemEvent ie) {
	// set the text field text to selected server
	Object value;
        
	if(ie.getSource() == cb) {
	     value = cb.getSelectedItem();
             tf3.setText(value.toString());
	}             
    }

    // Method to handle action events and item events
    private void getInput() {
	// Check to see if all the fields are filed out
        name = tf1.getText();
        serverID = tf2.getText();
        host = tf3.getText();
        
        if(jobType != null && name.length() != 0 && serverID.length() != 0 && host.length() != 0) {
	    // first thing is to change serverID String to an integer
            try {
		sID = Integer.parseInt(serverID);

		// now call the getFile method
                getFiles();	  
	    }
            catch(NumberFormatException ne) {
                String[] err = {"The Server ID is not an Integer", 
                                "Please re-enter an Integer",
                                ne.toString()}; 
		m.errPrint(err, "NumberFormat Error");
	    }
	}
        else {
	    // alert the user that he or she didn't fill out one of the fields
            String[] err = {"A required value was not entered or choosen.",
			  "Please make sure you didn't leave anything blank."};
            m.errPrint(err, "Input Error");
	} 
                        
    } 

    // Method to get the files from the server
    private void getFiles() {
	// instantiate the StatusPanel object
        sp = new StatusPanel("ChemConsoleServer@" + host);
        
        sp.println("Contacting Server...");
        
	// now instantiate the ChemConsole client object and catch the remote
	// exceptions if any
        try {
	    cl = new ChemConsoleClient(jobType, host);
            cl.setDaemon(true);

	    // check to see if server connected
            if(cl.server != null) {
		// start the application server and get the server ID
                int uID = cl.startUtilityServer();  

                if(uID != -1) {
		    // call the setfileID method
                    if(cl.setFileTypeID(uID, sID)) {
			// get the list of file from server
                        String[] fl = cl.getFileList(uID, name, null);
                       
                        if(fl != null && fl.length != 0) {
			    // get the file(s) from the server and delet them
                            sp.println("Getting " + (fl.length > 1 ? "files" : "file") + " From Server.");
			    for(int i  = 0; i < fl.length; i++) {
				sp.print(fl[i] + "...");
                                if(cl.getFile(uID, fl[i])) {
			            sp.println("OK");

				    // now delete it ont the server
                                    cl.delFile(uID, fl[i]);
				}
                                else {
				    sp.println("ERROR");
                                    break;                                   
				}				  
			    }
                          
			    // stop the Server the ChemConsoleClient
                            cl.Stop(uID); 
                            cl.stop();
                            cl = null;
			}
                        else {
			    // alert the user that no such file exist
                            sp.println("No Such File(s) found. Server stoped.");
                            cl.Stop(uID);
                            cl.stop();
			}  
		    }
                    else {
			sp.println("Invalid ServerID number, Server stop");
                        cl.Stop(uID);
                        cl.stop();
		    }
		}
                else {
		    // alert the user the server has reached maximum capacity
                    sp.println("The Server as reached the maximum number of" +
                               " allowed clients.\nConnection to Server "+ 
                               "rufused.");
                    cl.stop();
		}                  
	    }
            else {
		sp.println("Unable to Connect to Server...");
	    }
	}
        catch(RemoteException re) {
	    String[] err1 = {"A Remote Exception occured",
                             re.toString()};
            m.errPrint(err1, "Remote Exception");
	}    
    }
        
} // FileGetterPanel

