 
/**
 * MopacApp.java
 * This class is the class that actually runs the program 
 *
 * Created: Thu Apr 29 15:20:17 1999
 *
 * @author Nathan Stevens
 * @version 0.4
 */
import java.io.*;
import java.rmi.*;

public class MopacApp extends Thread
{
  private String[] Jobs, Jobs2;
  private Process process;
  private MopacPanel mp;
  private String command;
  private String Mode;
  private String[] com;    
  private Timer tm1, tm2;
  private ChemConsoleClient cl;
  private int id;
  private StatusPanel sp;
  private boolean sstate;                                 // The state of server

  public MopacApp(MopacPanel mp)
    {
      this.mp = mp;
      command = mp.getCommand();
      Mode = mp.getMode();
      Jobs = mp.getJobs();             
    }
   
  public void run()
    {
      // call the startjob method
      startJob();
    }

  private void startJob()
    {
      if(Mode.equals("local"))
	{
          tm1 = new Timer();
          // Disable the start button
          mp.setActive(false);
      
          com = new String[2];
          com[0] = command;
      
	  //start primary timer
          tm1.start();
	  
	  // start pr
          for(int i = 0; i < Jobs.length; i++)
	    {
              com[1] = Jobs[i];
              tm2 = new Timer();
              
	      // Now execute the command and wait for it to finish
              try
	        {
                  process =  Runtime.getRuntime().exec(com);
                  tm2.start();
                  process.waitFor();
                  tm2.stop();
	        }
              catch(IOException e)
	        {
	          System.out.println("Mopac Error : " + e);
                  this.stop();
	        }
              catch(InterruptedException e)
	        {
	          System.out.println("Mopac Error : " + e);
                  this.stop();
	        }    
	    }
	  //stop the primary timer
          tm1.stop();

          //Enable the start button
          mp.setActive(true);
          
	  // set the process to null
          process = null;
	}
     else if(Mode.equals("network"))
       {
          sp = new StatusPanel("Mopac Server(" +mp.getServer()+ ") Status");
          sp.println("Contacting Mopac Server...");
         //create a client object
         try
	   {
             cl  = new ChemConsoleClient("mopac", mp.getServer());
             cl.setDaemon(true);
             cl.start();

             if(cl.server != null)
	       {
                 id = cl.startAppServer();
                 if(id != -1)
		   { 
                     if(cl.isActive(id))
	               {
                         sstate = true;
                         sp.println("Connected to Mopac Server(" +id+")...");
                         sp.println("\nTransferring Data file(s) to Server.");
 
                         for(int i = 0; i < Jobs.length; i++)
		           {
                             if(cl.putFile(id, Jobs[i], Jobs[i])==false)
			       {
                                 sp.println("An Error occured while" + 
                                 "Transferring " +Jobs[i]+ " to the " +
                                 "Server.");

                                 cl.Stop(id);      // stop kill the server
                                 this.stop();
			       }
                             sp.println("Transferred " + Jobs[i]);
			    
			   }
		       
			 // now transfer the an array of file name and start 
			 // mopac on the server
                         if(mp.isRetrieve())
			   {
                             sp.println("\nStarting Mopac on Server.");
                             if(cl.runApp(id, Jobs))
			       {
                                 sp.println("Retrieving the Mopac output files");
                                 //get the list of ouptfiles and then retrieve
				 //them
                                 for(int i = 0; i < Jobs.length; i++)
				   {
                                     // a null String for getFileListMethod
                                     String ns = null;           

                                     int lg = Jobs[i].length() - 4;
                                     String fname = Jobs[i].substring(0,lg);
                                     String[] flist = cl.getFileList(id, fname, ns);
                                     
                                     if(flist != null)
                                       for(int j = 0; j < flist.length; j++)
					 {
                                           cl.getFile(id, flist[j]);
                                           sp.println("Recieved " + flist[j]);
					 }
                                     sp.println("\nDone...");
                                        
				   }
			       }
			     // Now stop the thread
                             cl.Stop(id);
                             sstate = false;
			   }
                         else
			   {
			     // Just start the Job on the server and get the 
			     // Results later;

                             cl.setRetrieve(id, false);
                             sp.println("\nStarting Mopac on the Server.");
                             cl.runApp(id, Jobs);
                             sp.println("\nOutput files will be left on Server");
                             sp.println("Done..");
                             sstate = false;
			   }   
		       }
                     else
		       {
                         sstate = false;
                         sp.println("Mopac Services are not provided " + 
                                      "by this Server");
                         cl.Stop(id);
                         this.stop();                         
		       }
		   }
                 else
	           {
                     sstate = false;
                     sp.println("The Mopac Server has reached the maximum " +
                                "number of allowed clients." +
                                "\nTry Back later.");
                     this.stop();		     
	           }
	       }
             else
	       {
                 // server is fucked up
                 sstate = false;
                 sp.println("Connnection to the Server refused");
                 this.stop();
	       }
	   }//end of try block
         catch(RemoteException re)
	  {
            System.out.println(re.toString());
	  }   
       }
    }  

  // Controller method used by BabelPanel
  public void stopJob()
    { 
      if(Mode.equals("local"))
        process.destroy();

      else if(Mode.equals("network"))
	{
          if(sstate)
          try
	    {
              cl.StopJob(id);
	    }
          catch(RemoteException re){}
	}      
    }

  public void stopAllJobs()
    {
      if(Mode.equals("local"))
	 {
           // Kill the entire thread
           stopJob();
           this.stop();
	 }
      else if(Mode.equals("network"))
	{
           if(sstate)
	    {
              try
		{
                  cl.StopJob(id);
                  cl.Stop(id);
		}
              catch(RemoteException re){}
	    }
          this.stop();
	}      
    }

  // Method to get the status of things
  public String[] getStatus()
    {
      String[] st = new String[1];

      if(Mode.equals("local"))
	{
          if(process != null)
	    {
              int[] time1 = tm1.getMinSec();
              int[] time2 = tm2.getMinSec();
      
              String t1 = time1[0] + "." + time1[1] +  " Min";
              String t2 = time2[0] + "." + time2[1] +  " Min";     

              String[] status = {"The Current Job is " + com[1],
                         "It has been runing for " + t2,
                         "The Total time  is " + t1};

              return status;
	    }
          else
	    {
              String[] status = {"There are no Mopac Jobs Runing"};
              return status;
	    }
	}
      else if(Mode.equals("network"))
	{
          if(sstate)
	    {
              try
		{
                  return cl.getStatus(id);
		}
              catch(RemoteException re){}
	    }
          else
	    {
              String[] status2 = {"Mopac Server is not runing",
                                "or Output files are being left on the Server"};
             
              return status2;
	    }
	}

      // nerver get here
      return st;
    } 
}













