
/**
 * ServerStatPanel.java
 * This class provides a way to check the stats of a ChemConsole Server
 *
 * Created: Sat Jul  3 18:37:04 1999
 *
 * @author Nathan Stevens
 * @version 0.4 July-99
 */
import java.awt.*;
import java.awt.event.*;
import java.rmi.*;
import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.border.*;
//import javax.swing.*;
//import javax.swing.text.*;
//import javax.swing.border.*;

public class ServerStatPanel extends JPanel
    implements ActionListener, ItemListener {
    
    private int N_COLS = 60;
    private int N_ROWS = 15;
    private String title = "Server Status";
    private String host;
    private JTextArea textArea;
    private JTextField tf1;
    private JComboBox slb;
    private ChemDialog cd;
    private ChemMessage m;
    private ChemConsoleClient cl;
    
    public ServerStatPanel() {
	// set the layout to border layout
        setLayout(new BorderLayout());

	/**
	 * Add the text area to north position
	 **/

        textArea = new JTextArea(N_ROWS, N_COLS);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);

        // add the textarea to scroll pane
        JScrollPane areaScrollPane = new JScrollPane(textArea);

        // add border to scroll pane
        Border border;
        border = new BevelBorder(BevelBorder.LOWERED);
        areaScrollPane.setBorder(border);
 
        // add the scroll pane to panel then add panel to frame
        add(areaScrollPane, "North");

	/**
	 * Add the server selector textfield and combo box
	 **/

        TitledBorder tborder;
           
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 5 ));
        tborder = new TitledBorder("Server Selector");
        tborder.setTitlePosition(TitledBorder.TOP);
        tborder.setTitleJustification(TitledBorder.CENTER);
        p1.setBorder(tborder);
	
	// now read in an array of servers by using a serverList object
        serverList serverlist = new serverList();

	// add the combo box
        slb = new JComboBox(serverlist.getServers());
        slb.addItemListener(this);
        p1.add(slb);
   
	// add the Jlable and a text
        JLabel lb1 = new JLabel("name  : ");
        p1.add(lb1);

	// now add the JTextField
        tf1 = new JTextField(20);
        p1.add(tf1);        
       
        add(p1, "Center");
       
	/**
	 * Add the OK and cancel buttons
	 **/ 
        
         JButton bt;
          
         JPanel p2 = new JPanel();
         p2.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 5));

         // add the ok button
         bt = new JButton("  OK  ");
         bt.addActionListener(this);
         bt.setActionCommand("ok");
         p2.add(bt);

         // add the cancel button
         bt = new JButton("Cancel ");
         bt.addActionListener(this);
         bt.setActionCommand("cancel");
         p2.add(bt);         	
         
         add(p2, "South");

	 // add this to the ChemDialog cd
         cd = new ChemDialog(title, this);
    }

    // Method to print to the text area
    private void print(String s) {
	textArea.append(s);
    }

    // Method to print and go to new line
    private void println(String s) {
	// Just call the print method with a new character appended to the 
	// string ,s.
        print(s + "\n");
    }

    // Method to clear the display
    private void clear() {
	textArea.setText("");
    }

    // Method to handel the action events
    public void actionPerformed(ActionEvent ae) {
	String cmd;
        cmd = ae.getActionCommand();
        
        if(cmd.equals("ok")) {
	    // call the getStatus method
            getInput();
	}
        else if(cmd.equals("cancel")) {
	    // close the ChemDialog
            cd.close();
	}
    }

    // Method to handel the item events
    public void itemStateChanged(ItemEvent ie) {
	Object value;
        
        if(ie.getSource() == slb) {
	     value = slb.getSelectedItem();
             tf1.setText(value.toString());
	}
    }    
    
    /**
     * Methods bellow this point handel the action and item events
     **/

    private void getInput() {
	//get the name of the server
        host = tf1.getText();
        
        // check to see if a server name was given if not give error
        if(host.length() != 0) {
	    //call the getStatus method
            getStats();
	}
        else {
	    // alert user that a server name wasn't given.
            String[] err = {"No Server Name Given.",
                            "Please enter a server name now."};

            m = new ChemMessage(this);
            m.errPrint(err, "Server Status Error"); 
	}        
    }

    // Method to get the status from the server
    private void getStats() {
	// instantiate the error dialog
        m = new ChemMessage(this);
        int uid;

	//print a message in textArea
        println("Contacting ChemConsole Server at " + host + "...");

	try {
	    cl = new ChemConsoleClient("utility", host);
            if(cl.server != null) {
		// get the id
                uid = cl.startUtilityServer();
                
                if(uid != -1) {
		    println("Connected to the ChemConsole Server...\n");

		    // call the getStats method for the server
                    String[] sa = cl.getServerStats(uid); 

		    // Stop the client thread then the server thread and then 
                    // set the client thread to null;
                    cl.Stop(uid);
                    cl.stop();
                    cl = null;

		    // now call the printStats Method
                    printStats(sa);
		}
                else {
		    println("Connection refused. The maximum "+
                            " number of allowed clients has been reached");
		}
	    }
	}
        catch(RemoteException re) {
	    String[] err = {"A RemoteException Error ocurred.", re.toString()};
            m.errPrint(err," RemoteException");
	}                                               
    }

    // Method to print the Server stats to the TextArea
    private void printStats(String[] stats) {
        // Print intro message
        println("Here are the Stats for " + host + "...\n");
        
	println("The maximum number of Application Server"+ 
                " clients allowed  : " + stats[0]);
        println("The maximum number of Utility Server clients" +
                " allowed : " + stats[1]);
        println("The number Application Server clients" +
                " currently connected : " + stats[2]);
       
        println("\nServer\t\t# of client(s)\t\t\tActive");
        println("======\t\t==============\t\t======");
        println("\nBabel\t\t"  +stats[3]+ "\t\t\t" + stats[4]);  
        println("Mopac\t\t"    +stats[5]+ "\t\t\t" + stats[6]);
        println("Gaussian\t\t" +stats[7]+ "\t\t\t" + stats[8]);
        println("Utility\t\t"  +stats[9]+ "\t\t\tN/A");

        println("");                  // Just print a blank
    }	
} // ServerStatPanel







