
/**
 * StatusPanel.java
 * This class acts as TextArea dialog so that the status of any thing can be
 * updated to the user in real time.
 * Created: Tue May 18 11:36:44 1999
 *
 * @author Nathan Stevens
 * @version 0.4   July-99
 */
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.border.*;
//import javax.swing.*;
//import javax.swing.text.*;
//import javax.swing.border.*;

public class StatusPanel extends JPanel implements ActionListener
{
  private ChemDialog cd;
  private static int N_ROWS = 10;        // Default number of rows
  private static int N_COLS = 50;         // Default number of cols  
  private JTextArea textArea;
  private static String title = "Status";

  // Constructors
  public StatusPanel()
    {
      this(title, N_ROWS, N_COLS);
    }
      
  public StatusPanel(String t)
    {
      this(t, N_ROWS, N_COLS);
    }
  public StatusPanel(int rows, int cols)
    {
      this(title, rows, cols);
    }
  public StatusPanel(String t, int rows, int cols)
    {
      setLayout(new BorderLayout());
      
      // Add the TextArea
      textArea = new JTextArea(rows, cols);
      textArea.setLineWrap(true);
      textArea.setWrapStyleWord(true);
      textArea.setEditable(false);

      // add the textarea to scroll pane
      JScrollPane areaScrollPane = new JScrollPane(textArea);

      // add border to scroll pane
      Border border;
      border = new BevelBorder(BevelBorder.LOWERED);
      areaScrollPane.setBorder(border);
 
      // add the scroll pane to panel then add panel to frame
      add(areaScrollPane, "Center");

      // add a button to panel at south position
      JPanel bp = new JPanel();
      bp.setLayout(new FlowLayout(FlowLayout.RIGHT, 5, 5));
     
      JButton button = new JButton("Dismiss");
      button.addActionListener(this);
      button.setActionCommand("dismiss");
      bp.add(button);
      
      add(bp, "South");
     
      // contruct the frame and set it visisble
      cd = new ChemDialog(t, this);
    }
  
  // Methods to print string to TextArea
  public void print(String s)
    {
      textArea.append(s);
    }
 
  public void println(String s)
    {
      textArea.append(s + "\n");
    }
  
  public void println(String[] s)
    {
      for(int i = 0; i < s.length; i++)
	{
          textArea.append(s[i] + "\n");
	}
    }
  
  // Method to clear the TextArea
  public void Clear()
    {
      textArea.setText("");
    }

  // Method to handel events
  public void actionPerformed(ActionEvent e)
    {
      String cmd = e.getActionCommand();
      
      if(cmd.equals("dismiss"))
          cd.close();
    }
}   

   

