
/**
 * serverList.java
 * 
 *
 * Created: Tue Jun 29 19:38:48 1999
 * This class reads all the config files and store the name of their 
 * servers and then provide them to the calling componets
 * @author Nathan Stevens
 * @version 0.4 July-99
 */
import java.util.*;
import java.io.*;

public class serverList  {
    
    private Vector sList;
    private static File bfile = new File("Config/babel.cfg");
    private static File mfile = new File("Config/mopac.cfg");
    // add gaussian here
    private TextInputFile f;
    private String dummy = null;
    private String serverName;

    public serverList() {
	// create the vector to store server names 
      sList  = new Vector();
      // Read in the babel Config file
      getBabelServers();
	
      // Read in the mopac config file
      getMopacServers();
   
      // Read in the gaussian config file
      getGaussianServers();
    }

    private void getBabelServers() {
	// read in the babel config file if it exist
	if(bfile.isFile()) { 
	    f = new TextInputFile(bfile);

	    // read in the other stuff in the file and dump them to null
	    for(int i = 0; i < 2; i++)   
		dummy = f.readString();
  

	    //  now read in the server strings
            while(!f.eof())
		sList.addElement(f.readString());
		   
            f.close();
	}
       
    }
 
    private void getMopacServers() {
	// read in the mopac server list
        if(mfile.isFile()){
	    f = new TextInputFile(mfile);

	    // read in the ohter variable in the file and dump them
            for(int i = 0; i < 2; i++)
		dummy = f.readString();

	    // now read in server names
            while(!f.eof()) {
		   
		// first check to see if the server name is already in 
		// the vector, if it is not add it.
                serverName = f.readString();
                       
                int position = sList.indexOf(serverName);
                if(position == -1)
		    sList.addElement(serverName);
			 
	    }
            f.close();
	}

        else{
	    // code
            System.out.println("can't find file" + mfile);
	}
			    
    }
  
    private void getGaussianServers(){
    
	// code
        
	// set dummy back to null to save memory, 32bit to be excact
        dummy = null;
    }
  
    // Method to return an array of servers
    public String[] getServers(){
    
        sList.trimToSize();
        String[] servers = new String[sList.size()];

        sList.copyInto(servers);
	/*debug code
        for(int i = 0; i < servers.length; i++){
	    
              System.out.println(servers[i]);
	    }
	    end of debug code*/

        return servers;
    }
}
   























