/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.horbc.ClassFile;

/**
 * Access flags, such as public, protected, static...
 */
public class AccessFlag {
  protected short flag;

  static final short ACC_PUBLIC       = 0x0001;  // class, method, variable
  static final short ACC_PRIVATE      = 0x0002;  // method, variable
  static final short ACC_PROTECTED    = 0x0004;  // method, variable
  static final short ACC_STATIC       = 0x0008;  // method, variable
  static final short ACC_FINAL        = 0x0010;  // class, method, variable
  static final short ACC_SYNCHRONIZED = 0x0020;  // method
  static final short ACC_THREADSAFE   = 0x0040;  // variable
  static final short ACC_TRANSIENT    = 0x0080;  // variable
  static final short ACC_NATIVE       = 0x0100;  // method
  static final short ACC_INTERFACE    = 0x0200;  // class
  static final short ACC_ABSTRACT     = 0x0400;  // class, method

  AccessFlag(short access_flags) {
    flag = access_flags;
  }

  public String toString() {
    String s = "";
    if (isPublic())
      s += "public ";
    if (isPrivate())
      s += "private ";
    if (isProtected())
      s += "protected ";
    if (isStatic())
      s += "static ";
    if (isFinal())
      s += "final ";
    if (isSynchronized())
      s += "synchronized ";
    if (isThreadsafe())
      s += "threadsafe ";
    if (isTransient())
      s += "transient ";
    if (isNative())
      s += "native ";
//    if (isInterface())
//      s += "interface ";
    if (isAbstract())
      s += "abstract ";
    return s;
  }

  public void print() {
    System.out.println(toString());
  }

  public boolean isPublic() {
    return (flag & ACC_PUBLIC) != 0 ? true : false; 
  }

  public boolean isPrivate() {
    return (flag & ACC_PRIVATE) != 0 ? true : false;
  }
  public boolean isProtected() { 
    return (flag & ACC_PROTECTED) != 0 ? true : false; 
  }
  public boolean isStatic() { 
    return (flag & ACC_STATIC) != 0 ? true : false; 
  }
  public boolean isFinal() { 
    return (flag & ACC_FINAL) != 0 ? true : false; 
  }
  public boolean isSynchronized() { 
    return (flag & ACC_SYNCHRONIZED) != 0 ? true : false; 
  }
  public boolean isThreadsafe() { 
    return (flag & ACC_THREADSAFE) != 0 ? true : false; 
  }
  public boolean isTransient() { 
    return (flag & ACC_TRANSIENT) != 0 ? true : false; 
  }
  public boolean isNative() { 
    return (flag & ACC_NATIVE) != 0 ? true : false; 
  }
  public boolean isInterface() { 
    return (flag & ACC_INTERFACE) != 0 ? true : false; 
  }
  public boolean isAbstract() { 
    return (flag & ACC_ABSTRACT) != 0 ? true : false; 
  }
}

