/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.horbc.ClassFile;

import java.io.DataInputStream;
import java.io.IOException;

/**
 * Attribute general form.
 */
class AttributeInfo {
  short attribute_name_index;
  String attribute_name;
  int attribute_length;	// length of value
  public AttributeSubType value;

  public AttributeInfo(DataInputStream ins, ConstantPool cp) throws IOException {
    attribute_name_index = ins.readShort();
    attribute_name = cp.toString(attribute_name_index);
    attribute_length = ins.readInt();
    if (cp.ConstantValue_index == attribute_name_index) {
      value = new ConstantValueAttribute(ins, cp, attribute_length);
    } else if (cp.Code_index == attribute_name_index) {
      value = new CodeAttribute(ins, cp, attribute_length);
    } else if (cp.SourceFile_index == attribute_name_index) {
      value = new SourceFileAttribute(ins, cp, attribute_length);
    } else if (cp.Exceptions_index == attribute_name_index) {
      value = new ExceptionAttribute(ins, cp, attribute_length);
    } else if (cp.LineNumberTable_index == attribute_name_index) {
      byte buf[] = new byte[attribute_length];
      ins.readFully(buf);
    } else if (cp.LocalVariableTable_index == attribute_name_index) {
      byte buf[] = new byte[attribute_length];
      ins.readFully(buf);
    } else {
//      System.err.println("Warning: unknown attribute type - "+cp.toString(attribute_name_index));
      byte buf[] = new byte[attribute_length];
      ins.readFully(buf);
//      System.err.println("buf size = "+buf.length+", attribute length = "+attribute_length);
    }
  }
  public void print(ConstantPool cp) {
    if (value != null)
      value.print(cp);
  }

  public String toString(ConstantPool cp) {
    if (value != null)
      return value.toString(cp);
    else
      return "";
  }
}

