/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */

package horb.horbc.ClassFile;

import java.io.DataInputStream;
import java.io.IOException;

/**
 * Stores attribute for code section. Currently it does'nt
 *    keep code itself.
 */
class CodeAttribute extends AttributeSubType {
  byte content[];
  int length;
  CodeAttribute(DataInputStream ins, ConstantPool cp, int length) throws IOException {
    this.length = length;
    // I don't need Code info
    content = new byte[length];
    ins.readFully(content);
  }

  public void print(ConstantPool cp) {
    System.out.println("Code attribute includes "+content.length+" bytes");
  }

  public String toString(ConstantPool cp) {
    return "code size "+length;
  }
}

