/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.horbc.ClassFile;

import java.io.DataInputStream;
import java.io.IOException;

/**
 * Stores attributes of source file.
 */
public class ExceptionAttribute extends AttributeSubType {
  public short numExceptions;
  public String exceptions[];

  ExceptionAttribute(DataInputStream ins, ConstantPool cp, int length) throws IOException {
    numExceptions = ins.readShort();
    exceptions = new String[numExceptions];
    for (int i = 0; i < numExceptions; i++) {
      short index = ins.readShort();
      if (index != 0)
	exceptions[i] = cp.toString(index).replace('/', '.');
    }
  }
  public void print(ConstantPool cp) {
    if (numExceptions > 0)
      System.out.print("throws ");
    for (int i = 0; i < numExceptions; i++) {
      if (exceptions[i] != null) {
	System.out.print(exceptions[i]);
	if (i < numExceptions-1)
	  System.out.print(", ");
      }
    }
  }
  public String toString(ConstantPool cp) {
    return toString();
  }

  public String toString() {
    String s = "";
    for (int i = 0; i < numExceptions; i++) {
      if (exceptions[i] != null) {
	s += exceptions[i];
	if (i < numExceptions-1)
	  s += ", ";
      }
    }
    return s;
  }
}

