/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.horbc.ClassFile;

import java.io.DataInputStream;
import java.io.IOException;

/**
 * Parse and print field (class/instance variable) 
 * 		info structure.
 */
public class FieldInfo {
  static final int major_version = 1;
  static final int minor_version = 0;

  short access_flags;
  public AccessFlag flag;
  short name_index;
  public String name;
  short signature_index;
  public Signature sig;
  short attributes_count;
  AttributeInfo attributes[];

  FieldInfo(DataInputStream ins, ConstantPool cp) throws IOException, ClassFileException {
    access_flags = ins.readShort();
    flag = new AccessFlag(access_flags);
    name_index = ins.readShort();
    name = cp.toString(name_index);
    signature_index = ins.readShort();
    try {
      sig = new Signature(cp.toString(signature_index));
    } catch (ClassFileException e) {
      throw new ClassFileException("Illegal signature in field "+name);
    }
    attributes_count = ins.readShort();
    // why is this always zero?
    // System.out.println("attribute count = "+attributes_count);
    if (attributes_count > 0) {
      attributes = new AttributeInfo[attributes_count];
      for (int i = 0; i < attributes_count; i++) {
	attributes[i] = new AttributeInfo(ins, cp);
      }
    }
  }

  public void print(ConstantPool cp) {
    System.out.print("  "+ flag.toString() + " ");
    System.out.print(sig.toStringArg() + " ");
    System.out.print(cp.toString(name_index));
    if (attributes_count > 0) {
      // this won't work.
      System.out.print(" = ");
      for (int i = 0; i < attributes_count; i++) {
	System.out.print(attributes[i].toString(cp));
      }
    }
    System.out.println(";");
  }
}

