/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribute this software and
 * for peaceful purposes and without fee is hereby granted provided
 * this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 * 
 */

package horb.horbc.ClassFile;

/**
 * Defines data types for signature
 */
public class JavaType {
  public char type;
  public String typeName;
  public int arrayDim = 0;

  public static final char T_ANY    = 'A';      // any
  public static final char T_BYTE   = 'B';	// byte
  public static final char T_CHAR   = 'C';	// char
  public static final char T_DOUBLE = 'D';	// double
  public static final char T_ENUM   = 'E';	// enum
  public static final char T_FLOAT  = 'F';	// float
  public static final char T_INT    = 'I';     // integer
  public static final char T_LONG   = 'J';	// long
  public static final char T_SHORT  = 'S';	// signed short
  public static final char T_BOOL   = 'Z';	// boolean
  public static final char T_CLASS  = 'L';	// class  L<class>;
  public static final char T_VOID   = 'V';	// void
  public static final char T_ARRAY  = '[';	// array

  public static final String S_ANY = "any";
  public static final String S_BYTE = "byte";
  public static final String S_CHAR = "char";
  public static final String S_DOUBLE = "double";
  public static final String S_ENUM = "enum";
  public static final String S_FLOAT = "float";
  public static final String S_INT  = "int";
  public static final String S_LONG = "long";
  public static final String S_SHORT = "short";
  public static final String S_BOOL = "boolean";
  public static final String S_CLASS = "class";
  public static final String S_VOID = "void";
}

