/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.horbc.ClassFile;

import java.io.DataInputStream;
import java.io.IOException;

/**
 * Stores info of methods.
 */
public class MethodInfo {
  short access_flags;

  /**
   * Access flag of this method.
   */
  public AccessFlag flag;
  short name_index;
  /**
   * Method name.
   */
  public String methodName;
  short signature_index;

  /**
   * Signature of this method.
   */
  public Signature sig;

  /**
   * Number of attributes for this methos.
   */
  public short attributes_count;

  /**
   * Attributes of this method.
   */
  AttributeInfo attributes[];

  /**
   * Exception table
   */
  public AttributeInfo exceptions;

  MethodInfo(DataInputStream ins, ConstantPool cp) throws IOException, ClassFileException {
    access_flags = ins.readShort();
    flag = new AccessFlag(access_flags);
    name_index = ins.readShort();
    methodName = cp.toString(name_index);
    signature_index = ins.readShort();
    try {
      sig = new Signature(cp.toString(signature_index));
    } catch (ClassFileException e) {
      throw new ClassFileException("Illegal signature in method "+methodName);
    }
    attributes_count = ins.readShort();
    if (attributes_count > 0) {
      attributes = new AttributeInfo[attributes_count];
      for (int i = 0; i < attributes_count; i++) {
	attributes[i] = new AttributeInfo(ins, cp);
	if (attributes[i].attribute_name.equals("Exceptions"))
	  exceptions = attributes[i];
      }
    }
  }

  public void print(ConstantPool cp) {
    System.out.print("  "+ flag.toString());
    System.out.print(sig.toStringReturnType()+" ");
    System.out.print(methodName+"(");
    System.out.print(sig.toStringArg()+") ");
    // System.out.print("attributes count "+attributes_count);
    if (exceptions != null) {
      exceptions.print(cp);
    }
    if (attributes_count > 0) {
      System.out.println(" {");
      for (int i = 0; i < attributes_count; i++) {
	System.out.println("     "+attributes[i].toString(cp));
      }
      System.out.println("  }");
    } else {
      System.out.println(";");
    }
  }
}

