/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribute this software and
 * for peaceful purposes and without fee is hereby granted provided
 * this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 * 
 */

package horb.horbc.ClassFile;

/**
 * Defines and stores class/method signature
 */
class Signature {
  protected String sig;
  int sigLen;
  protected int p;

  /**
   * Type of arguments.
   */
  public JavaType args[];
  public int numArg = 0;
  /**
   * Return type.
   */
  public JavaType retType;
  boolean parsed = false;

  /**
   * call with Java signature string, like;
   * <pre>
   *     Signature s = new("(IFD)V");
   * </pre>
   */
  Signature(String s) throws ClassFileException {
    sig = s;
    sigLen = sig.length();
    parse();
  }

  public static void main(String argv[]) throws ClassFileException {
    Signature s = new Signature(argv[0]);
    s.print();
  }

  public String toStringArg() {
    String s = "";
    for (int i = 0; i < numArg; i++) {
      s  += args[i].typeName;
      for (int d = 0; d < args[i].arrayDim; d++)
	s += "[]";
      if (i < numArg-1)
	s += ", ";
    }
    return s;
  }

  public String toStringReturnType() {
    if (retType == null)
      return "";
    String s = retType.typeName;
    for (int d = 0; d < retType.arrayDim; d++)
      s += "[]";
    return s;
  }

  public void print() {
    System.out.println(toStringArg());
    System.out.println(toStringReturnType());
  }

  private void parse() throws ClassFileException {
    beginParse();
    parse2();
  }

  public final void beginParse() {
    parsed = true;
    p = 0;
  }

  private final void parse2() throws ClassFileException {
    int i = numArg;
    JavaType t = getNext();
    if (t == null) {
      // System.err.println("null");
    } else {
      // System.err.println(t.type);
    }

    if (t == null) {
      if (numArg > 0)
	args = new JavaType[numArg];
      return;
    } else if (t.type == '(') {
      parse2();
    } else if (t.type == ')') {
      retType = getNext();	// e.g. void foo() -> ()V
      parse2();
    } else {
      numArg++;
      parse2();
      args[i] = t;
    }
  }

  public JavaType getNext() throws ClassFileException {
    JavaType t = new JavaType();

    while (p < sigLen) {
      char c = sig.charAt(p);
      t.type = c; 
      p++;
      switch (c) {
      case JavaType.T_BYTE:
	t.typeName = t.S_BYTE; return t;
      case JavaType.T_CHAR:
	t.typeName = t.S_CHAR; return t;
      case JavaType.T_DOUBLE:
	t.typeName = t.S_DOUBLE; return t;
      case JavaType.T_FLOAT:
	t.typeName = t.S_FLOAT; return t;
      case JavaType.T_INT:
	t.typeName = t.S_INT; return t;
      case JavaType.T_LONG:
	t.typeName = t.S_LONG; return t;
      case JavaType.T_SHORT:
	t.typeName = t.S_SHORT; return t;
      case JavaType.T_BOOL:
	t.typeName = t.S_BOOL; return t;
      case JavaType.T_VOID:
	t.typeName = t.S_VOID; return t;
      case '(':
	return t;
      case ')':
	return t;
      case JavaType.T_ARRAY:		// '['
	t.arrayDim++;
	break;
      case JavaType.T_CLASS: {
	int start = p;		// remember start point of class name
	while (p < sigLen) {	// skip until ';'   e.g. Lclass;
	  c = sig.charAt(p);
	  p++;
	  if (c == ';')
	    break;
	}
	if (c != ';')
	  throw new ClassFileException("invalid class name");
	t.typeName = new String();
	t.typeName = sig.substring(start, p-1);	// -1 for ';'
	t.typeName = t.typeName.replace('/', '.');// package/class -> package.class
	return t;
      }
      default:
	System.err.println("Warning: unknown data type - " +c);
	break;
      }
    }

    return null; // end of signature
  }

}

