/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.horbc;
import java.util.*;
import java.io.*;

class ClassPath {
  static Vector classPaths;
  File path;
  private String fullPath;
  private String fileName;
  private String directory;

  public static void main(String argv[]) {
    ClassPath c = new ClassPath(argv[0]);
    System.out.println("full path: "+c.getFullPath());
    System.out.println("file name: "+c.getFileName());
    System.out.println("directory: "+c.getDirectory());
    System.out.println("class name: "+c.getClassName());
  }

  public ClassPath(String className) {
    search(className, (String)null);
  }

  public ClassPath(String className, String CLASSPATH) {
    search(className, CLASSPATH);
  }

  private void search(String className, String CLASSPATH) {
    if (classPaths == null)
      parseClassPath(CLASSPATH);
    
    // package.class -> package/class
    className = className.replace('.', File.separatorChar);
    String classFile = className+".class";

    // search class file
    for (Enumeration e = classPaths.elements(); e.hasMoreElements();) {
      String dir = (String)e.nextElement();
      File file;
      if (dir.equals(".") || dir.equals("."+File.separator))
	file = new File(classFile);
      else
	file = new File(dir+File.separator+classFile);
//System.out.println(file);      
      if (file.exists()) {
	this.path = file;
	fullPath = file.getAbsolutePath();
//System.out.println(fullPath);
	fileName = file.getName();
	directory = file.getParent();
	if (directory == null)
	  directory = ".";
	break;
      }
    }
  }
  
  public String getFullPath() {
    return fullPath;		// it can be null
  }
  public String getDirectory() {
    return directory;		// it can be null
  }
  public String getFileName() {
    return fileName;		// it can be null
  }

  public String getClassName() {
    if (fileName == null)
      return null;
    int i = fileName.indexOf('.');
    if (i > 0)
      return fileName.substring(0, i);
    else
      return fileName;
  }

  public boolean exists() {
    return (fullPath == null) ? false : true;
  }

  private void parseClassPath(String paths) {
    //
    // parse CLASSPATH
    //
    classPaths = new Vector();
    if (paths == null)
      paths = System.getProperty("java.class.path");
      
    char sep = File.pathSeparatorChar;
    int s = 0;
    int sepAt = s;
    while (s < paths.length() && (sepAt = paths.indexOf(sep, s)) >= 0) {
      if (s < sepAt) {
	String path = paths.substring(s, sepAt);
	// eliminate last separator if exists
	if (path.length() > 1 && path.charAt(path.length()-1) == sep)
	  path = path.substring(path.length()-1);
	classPaths.addElement(path);
	//	  System.out.println(path);
      }
      s = sepAt + 1;
    }
    if (s < paths.length())
      classPaths.addElement(paths.substring(s, paths.length()));
    classPaths.addElement(".");
  }
}
   
