/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.horbc;
import java.util.*;
import java.io.*;

class ExecPath {
  static Vector execPaths;
  File path;
  private String fullPath;
  private String fileName;
  private String directory;
  boolean windows = false;

  public static void main(String argv[]) {
    ExecPath c = new ExecPath(argv[0]);
    System.out.println("full path: "+c.getFullPath());
    System.out.println("file name: "+c.getFileName());
    System.out.println("directory: "+c.getDirectory());
    System.out.println("exec name: "+c.getExecName());
  }

  public ExecPath(String execName) {
    search(execName, (String)null);
  }

  public ExecPath(String execName, String EXECPATH) {
    search(execName, EXECPATH);
  }

  private void search(String execName, String EXECPATH) {
    if (execPaths == null)
      parseExecPath(EXECPATH);
    
    // package.exec -> package/exec
//    execName = execName.replace('.', File.separatorChar);
    String execFile = execName;
    if (windows)
      execFile = execFile+".exe";

    // search exec file
    for (Enumeration e = execPaths.elements(); e.hasMoreElements();) {
      File file = new File((String)e.nextElement()+File.separator+".."+File.separator+"bin"+File.separator+execFile);
      if (file.exists()) {
	this.path = file;
	fullPath = file.getAbsolutePath();
	fileName = file.getName();
	directory = file.getParent();
	break;
      }
    }
  }
  
  public String getFullPath() {
    return fullPath;		// it can be null
  }
  public String getDirectory() {
    return directory;		// it can be null
  }
  public String getFileName() {
    return fileName;		// it can be null
  }

  public String getExecName() {
    if (fileName == null)
      return null;
    int i = fileName.indexOf('.');
    if (i > 0)
      return fileName.substring(0, i);
    else
      return fileName;
  }

  private void parseExecPath(String paths) {

    String os = System.getProperty("os.name");
    if (os.startsWith("Windows"))
      windows = true;

    //
    // parse CLASSPATH
    //
    execPaths = new Vector();
    if (paths == null)
      paths = System.getProperty("java.class.path");
      
    char sep = File.pathSeparatorChar;
    int s = 0;
    int sepAt = s;
    while (s < paths.length() && (sepAt = paths.indexOf(sep, s)) >= 0) {
      if (s < sepAt) {
	String path = paths.substring(s, sepAt);
	// eliminate last separator if exists
	if (path.length() > 1 && path.charAt(path.length()-1) == sep)
	  path = path.substring(path.length()-1);
	execPaths.addElement(path);
	//	  System.out.println(path);
      }
      s = sepAt + 1;
    }
    if (s < paths.length())
      execPaths.addElement(paths.substring(s, paths.length()));
  }
}
   
