/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.horbc;

import horb.horbc.ClassFile.*;
import java.io.DataInputStream;
import java.io.PrintStream;

/**
 * Generates object receiver method _recvInstance()
 */
class ObjectReceiver {
  PrintStream os;

  void objectReceiver(ClassFile cf, PrintStream os, Receiver recv, boolean hasReviveHook) {
    this.os = os;

    putln("  public Object _recvInstance(IOCI io, Object obj, boolean superclass, Goldberg gb, byte place) throws HORBException, IOException {");

    //
    // if interface
    //
    if (cf.flag.isInterface()) {
      putln("    return null;");
      putln("  }");
      return;
    }

    //
    // if class
    //

    //
    // receive super class first. This is a bit complex logic.
    // BasicIOCI calls the subest class with superclass flag false.
    // At this point, create an instance of the class.
    // The class calls super class's _recvInstance with superclass
    // flag true. The super classes fills the instance.
    //
    putln("    "+cf.className+" o = null;");
    putln("    if (superclass) {");
    if (horbc.ignoreSuper == false && cf.hasSuperClass)
      putln("      super._recvInstance(io, obj, true, gb, place);");
    putln("      o = ("+cf.className+")obj;");
    putln("    } else {");
    if (cf.flag.isAbstract() == false) {
      if (horbc.ignoreSuper == false && cf.hasSuperClass) {
	putln("      o = new "+cf.className+"();");
	putln("      gb.put(o);");
	putln("      super._recvInstance(io, o, true, gb, place);");
      } else {
	putln("      o = new "+cf.className+"();");
	putln("      gb.put(o);");
      }
    }
    putln("    }");

    //
    // receive this class' fields
    //
    for (int fieldNo = 0; fieldNo < cf.fields_count; fieldNo++) {
      FieldInfo fi = cf.fields[fieldNo];
      if (fi.flag.isPrivate() || fi.flag.isStatic() || fi.flag.isFinal() || fi.flag.isTransient() || fi.name.endsWith("_Transient"))
	continue;

      // generate receive code
      recv.recv("o."+fi.name, fi.sig.args[0], false);
    }

    // call transfer end hook if exists
    if (hasReviveHook) {
      putln("    if (o != null)");
      putln("      o._reviveHook(place);");
    }

    putln("    return (Object)o;");
    putln("  }");
  }

  private final void putln(String s) {
    os.println(s);
  }

  private final void put(String s) {
    os.print(s);
  }

  private final void putln() {
    os.println();
  }
}
