/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.horbc;

import horb.horbc.ClassFile.*;
import java.io.DataInputStream;
import java.io.PrintStream;

/**
 * Generates object sender method, _sendInstance()
 */
class ObjectSender {
  PrintStream os;

  void objectSender(ClassFile cf, PrintStream os, Sender send, boolean hasFreezeHook) {

    this.os = os;
    putln("  public void _sendInstance(IOCI io, Object obj, Loopy loopy, byte place) throws HORBException, IOException {");

    //
    // if interface
    //
    if (cf.flag.isInterface()) {
      putln("  }");
      return;
    }

    //
    // if class
    //

    // send super class first
    if (horbc.ignoreSuper == false && cf.hasSuperClass)
      putln("    super._sendInstance(io, obj, loopy, place);");

    // cast to my class
    if (cf.fields_count > 0 || hasFreezeHook)
      putln("    "+cf.className+" o = ("+cf.className+")obj;");
    
    // call transfer end hook if exists
    if (hasFreezeHook) {
      putln("    if (o != null)");
      putln("      o._freezeHook(place);");
    }

    // send fields
    for (int fieldNo = 0; fieldNo < cf.fields_count; fieldNo++) {
      FieldInfo fi = cf.fields[fieldNo];
      if (fi.flag.isPrivate()) {
	System.err.println("Warning: "+cf.className+": private variable '"+fi.name+"' will not be copied when this object is transfered.");
	continue;
      }
      
      if (fi.flag.isStatic() || fi.flag.isFinal() || fi.flag.isTransient()) {
	continue;
      }

      if (fi.name.endsWith("_Transient")) {
	System.err.println("Warning: "+cf.className+": \"int foo_Transient\" is obsolete. Use \"transient int foo\"");
	continue;
      }
	      
      // generate send code
      send.send("o."+fi.name, fi.sig.args[0], false);
    }
    putln("  }");
  }

  private final void putln(String s) {
    os.println(s);
  }

  private final void put(String s) {
    os.print(s);
  }

  private final void putln() {
    os.println();
  }
}
