/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.horbc;

import horb.horbc.ClassFile.*;
import java.io.DataInputStream;
import java.io.PrintStream;

/**
 * Generates data receiver.
 */
class Receiver {
  ClassFile cf;
  PrintStream os;
  boolean newGoldberg;	// if true, recvObject should have a new Goldberg.

  Receiver(ClassFile cf, PrintStream os) {
    this.cf = cf;
    this.os = os;
  }

  /** send data. */
  void recv(String item, JavaType type, boolean newGoldberg) {
    this.newGoldberg = newGoldberg;
    if (type.arrayDim == 0)
      recvItem(item, type);
    else
      recvArray(item, type);
  }

  void recvArray(String item, JavaType type) {
    recvArray2(item, type, item, 0);
  }

  /** receive an array. */
  private void recvArray2(String item, JavaType type, String outer, int dim) {
    if (dim == type.arrayDim) {
      // foo: the last dimension
      recvItem(outer, type);
      return;
    } else if (dim == type.arrayDim-1) {
      // foo[]: specially treat one dimensional array for optimization
      if (type.type != JavaType.T_CLASS
	  || "java.lang.String".equals(type.typeName)) {
	recv1DArray(outer, type);
	return;
      }
    }
    // foo[][]: at least 2 dimention last
    os.println("    {");
    os.println("    int len"+dim+" = io.recvInt();");
    os.println("    if (len"+dim+" >= 0) {");
    os.print("        "+outer+" = new "+type.typeName+"[len"+dim+"]");
    for (int d = 1; d < type.arrayDim-dim; d++)
      os.print("[]");
    os.println(";");
    os.println("      for (int i"+dim+"=0; i"+dim+" < len"+dim+"; i"+dim+"++) {");
    recvArray2(item, type, outer+"[i"+dim+"]", dim+1);
    os.println("      }");
    os.println("    }");
    os.println("    }");
  }

  /** receive a non array first class object. */
  void recvItem(String item, JavaType type) {
    switch (type.type) {
    case JavaType.T_BYTE:
      os.println("    "+item+"= io.recvByte();");
      break;
    case JavaType.T_CHAR:
      os.println("    "+item+"= io.recvChar();");
      break;
    case JavaType.T_DOUBLE:
      os.println("    "+item+"= io.recvDouble();");
      break;
    case JavaType.T_FLOAT:
      os.println("    "+item+"= io.recvFloat();");
      break;
    case JavaType.T_INT:
      os.println("    "+item+"= io.recvInt();");
      break;
    case JavaType.T_LONG:
      os.println("    "+item+"= io.recvLong();");
      break;
    case JavaType.T_SHORT:
      os.println("    "+item+"= io.recvShort();");
      break;
    case JavaType.T_BOOL:
      os.println("    "+item+"= io.recvBoolean();");
      break;
    case JavaType.T_VOID:
      System.err.println("can't happen! void argument type");
      break;
    case JavaType.T_CLASS:
      // special treatment for String
      if ("java.lang.String".equals(type.typeName))
	os.println("    "+item+" = io.recvString();");
      else
	recvObject(item, type);
      break;
    }
  }

  /**
   * receive a one dimensional array. This method cannot receive objects
   * except string. 
   */
  void recv1DArray(String item, JavaType type) {
    switch (type.type) {
    case JavaType.T_BYTE:
      os.println("    "+item+"= io.recvByteArray();");
      break;
    case JavaType.T_CHAR:
      os.println("    "+item+"= io.recvCharArray();");
      break;
    case JavaType.T_DOUBLE:
      os.println("    "+item+"= io.recvDoubleArray();");
      break;
    case JavaType.T_FLOAT:
      os.println("    "+item+"= io.recvFloatArray();");
      break;
    case JavaType.T_INT:
      os.println("    "+item+"= io.recvIntArray();");
      break;
    case JavaType.T_LONG:
      os.println("    "+item+"= io.recvLongArray();");
      break;
    case JavaType.T_SHORT:
      os.println("    "+item+"= io.recvShortArray();");
      break;
    case JavaType.T_BOOL:
      os.println("    "+item+"= io.recvBooleanArray();");
      break;
    case JavaType.T_VOID:
      System.err.println("can't happen! void argument type");
      break;
    case JavaType.T_CLASS:
      // special treatment for String
      if ("java.lang.String".equals(type.typeName))
	os.println("    "+item+" = io.recvStringArray();");
      else {
	System.err.println("internal error! receiving object array");
	System.exit(1);
      }
      break;
    }
  }

  /** receive a non array object. */
  private void recvObject(String item, JavaType type) {
    os.println("    //recv "+type.typeName+" "+item);

    os.print("    "+item+" = ("+type.typeName+")io.recvObject(\""
	   +type.typeName+"\", ");
    if (newGoldberg)
      os.println("new Goldberg());");
    else
      os.println("gb);");
  }
}
