/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.horbc;

import horb.horbc.ClassFile.*;
import java.io.DataInputStream;
import java.io.PrintStream;

/**
 * Generates data sender.
 */
class Sender {
  ClassFile cf;
  PrintStream os;
  boolean newLoopy;		// if true, sendObject should have a new Loopy.

  Sender(ClassFile cf, PrintStream os) {
    this.cf = cf;
    this.os = os;
  }

  /** send data. */
  void send(String item, JavaType type, boolean newLoopy) {
    this.newLoopy = newLoopy;
    if (type.arrayDim == 0)
      sendItem(item, type);
    else
      sendArray(item, type);
  }
    
  private void sendArray(String item, JavaType type) {
    sendArray2(item, type, item, 0);
  }

  /** send an array. */
  private void sendArray2(String item, JavaType type, String outer, int dim) {

    if (dim == type.arrayDim) {
      // foo: the last dimension
      sendItem(outer, type);
      return;
    } else if (dim == type.arrayDim-1) {
      // foo[]: specially treat one dimensional array for optimization
      if (type.type != JavaType.T_CLASS
	  || "java.lang.String".equals(type.typeName)) {
	send1DArray(outer, type);
	return;
      }
    }
    // foo[][]: at least 2 dimention last
    os.println("    {");
    os.println("      int len"+dim+" = "+outer+" == null ? (-1) : "+outer+".length;");
    os.println("      io.sendInt(len"+dim+");");
    os.println("      for (int i"+dim+"=0; i"+dim+" < len"+dim+"; i"+dim+"++) {");
    sendArray2(item, type, outer+"[i"+dim+"]", dim+1);
    os.println("      }");
    os.println("    }");
  }

  /** send a non array first class object. */
  private void sendItem(String item, JavaType type) {
    switch (type.type) {
    case JavaType.T_BYTE:
      os.println("    io.sendByte("+item+");");
      break;
    case JavaType.T_CHAR:
      os.println("    io.sendChar("+item+");");
      break;
    case JavaType.T_DOUBLE:
      os.println("    io.sendDouble("+item+");");
      break;
    case JavaType.T_FLOAT:
      os.println("    io.sendFloat("+item+");");
      break;
    case JavaType.T_INT:
      os.println("    io.sendInt("+item+");");
      break;
    case JavaType.T_LONG:
      os.println("    io.sendLong("+item+");");
      break;
    case JavaType.T_SHORT:
      os.println("    io.sendShort("+item+");");
      break;
    case JavaType.T_BOOL:
      os.println("    io.sendBoolean("+item+");");
      break;
    case JavaType.T_VOID:
      System.err.println("can't happen! void argument type");
      break;
    case JavaType.T_CLASS:
      // special treatment for String
      if ("java.lang.String".equals(type.typeName))
	os.println("    io.sendString("+item+");");
      else
	sendObject(item, type);	// usual objects
      break;
    }
  }

  /**
   * send a one dimensional array. This method cannot send objects except
   * string. 
   */
  private void send1DArray(String item, JavaType type) {
    switch (type.type) {
    case JavaType.T_BYTE:
      os.println("    io.sendByteArray("+item+");");
      break;
    case JavaType.T_CHAR:
      os.println("    io.sendCharArray("+item+");");
      break;
    case JavaType.T_DOUBLE:
      os.println("    io.sendDoubleArray("+item+");");
      break;
    case JavaType.T_FLOAT:
      os.println("    io.sendFloatArray("+item+");");
      break;
    case JavaType.T_INT:
      os.println("    io.sendIntArray("+item+");");
      break;
    case JavaType.T_LONG:
      os.println("    io.sendLongArray("+item+");");
      break;
    case JavaType.T_SHORT:
      os.println("    io.sendShortArray("+item+");");
      break;
    case JavaType.T_BOOL:
      os.println("    io.sendBooleanArray("+item+");");
      break;
    case JavaType.T_VOID:
      System.err.println("can't happen! void argument type");
      System.exit(1);
      break;
    case JavaType.T_CLASS:
      if ("java.lang.String".equals(type.typeName))
	os.println("    io.sendStringArray("+item+");");
      else {
	System.err.println("internal error! sending object array");
	System.exit(1);
      }
      break;
    }
  }

  /** send a non array object. */
  private void sendObject(String item, JavaType type) {
    os.println("    //send "+type.typeName+" "+item);

    os.print("    io.sendObject("+item+", \""+type.typeName+"\", ");
    if (newLoopy)
      os.println("new Loopy());");
    else
      os.println("loopy);");
  }
}
