/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */

package horb.orb;

import java.io.*;
import java.util.*;

/**
 * 
 */
public class AclStatus {

  /**
   * ACL name. set this before making object ACL_Impl.
   */
  public String name;

  /**
   * ACL source. one of filename or HorbURL. set this before making object 
   * ACL_Impl.
   * <pre>
   *   horb://hostname/aclMaster
   *   file:///aclfile.acl
   *   aclfile.acl
   * </pre>
   */
  public String source;

  /**
   * redistributable or not. default no. set this before making object 
   * ACL_Impl.
   */
  public boolean redistributable = false;

  /**
   * ACL refresh interval in seconds. If 0, refresh does not occur, otherwise
   * ACL controller redownload list from the source. Default 0.<br>
   * This value is a per system value. Set this before making object ACL_Impl.
   */
  public long refreshInterval = 0;

  /**
   * last load or refresh time.
   */
  public long lastLoadTime;

  /**
   * last modified time of the file. This value is meaningless as
   * an absolute time.
   */
  public long lastModifiedTime;

  public void list(PrintStream ps) {
    ps.println("name: "+name);
    ps.println("source: "+source);
    ps.println("redistributalbe: "+redistributable);
    ps.println("refresh interval (sec): "+refreshInterval);
    Date d = new Date(lastLoadTime);
    ps.println("last load time: "+d.toString());
  }
}
