/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.orb;

/**
* Signals an exception, for example null pointer access, occures in 
 * skeleton side during passing arguments. The proxy object is no 
 * longer usable. Create a new proxy object and dispose the errornous
 * proxy object.
 * <p>
 * TIPS!
 * <p>
 * <UL>
 * <LI> ArgumentException.toString() returns exception message of the remote
 * exception.
 * <LI> horb server always dumps stack trace when argument exception occurs.
 * </UL>
 */
public class ArgumentException extends HORBException {
  public ArgumentException(String s) {
    super(s);
  }
  public ArgumentException(Exception e) {
    super(e.toString());
  }
}
