/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.orb;

/**
 * Asynchronous Method Call Handler. Asynchronous method handler object
 * must inherit this interface and must have run() method.
 * <pre>
 *   class hander implements AsyncMethodHandler {
 *     Server server;
 *     void setServer(Server server) {
 *       this.server = server;
 *     }
 *     public void run(int tag) {
 *        value = server.method_Receive(0);
 *        System.out.println("value for "+tag+" is " value);
 *     }
 *   }
 * Caller:
 *   //
 *   server._setHandler(new Handler(), 3);
 *   server.method_Request(arg);
 *   // handler will be called when the method completes.
 * </pre>
 */
public interface AsyncMethodHandler {
  /**
   * Entry point of asynchronous method call handler. Once a handler is set
   * by Proxy._setHandler(), this method is called with tag when asynchronous 
   * method call completes.
   *
   * @param tag  arbitrary integer number
   * @see Proxy#_setHander
   */
  public void run(int tag);
}
