/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.orb;

import java.io.*;
import java.util.Date;

/**
 * Information about Foffile (freezed object file). Every foffile (*.fof)
 * has this FofInfo as a header.
 */
public class FofInfo extends IOCIInfo {

  /** class name of stored the object */
  public String className;

  /** major version number of the class */
  public short major_version;

  /** minor version number of the class */
  public short minor_version;

  /** foffile URL */
  public String url;

  /** creation time */
  public long createTime;

  /** hostname */
  public String hostname;

  /** user name */
  public String username;

  /** reserved */
  public int reserve1;

  public FofInfo() {}

  public FofInfo(IOCI ioci, String url, Object o) {
    super(ioci);

    if (o != null) {
      try {
	className = o.getClass().getName();
	Proxy proxy = (Proxy)Class.forName(className+"_Proxy").newInstance();
	major_version = proxy._getMajorVersion();
	minor_version = proxy._getMinorVersion();
      } catch (Exception e) {
      e.printStackTrace();}
    }
    this.url = url;
    createTime = System.currentTimeMillis();
    try {
      hostname = ioci.getLocalHostName();
    } catch (Exception e) {}
    username = System.getProperty("user.name");
    reserve1 = 0;
  }

  public void list(PrintStream ps) {
    super.list(ps);
    ps.println("class: "+className);
    ps.println("proxy version: "+major_version+"."+minor_version);
    ps.println("URL: "+url);
    Date createTime = new Date(this.createTime);
    ps.println("create time: "+createTime.toString());
    ps.println("hostname: "+hostname);
    ps.println("username: "+username);
  }
}
