/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.orb;

import java.io.*;
import java.util.*;
import java.net.*;

class HostList {
  static final byte NAME = 0;
  static final byte ADDR = 1;

  byte tag;

  String name;
  byte addr[];

  boolean isAny() {
    return (tag == ADDR && addr[0] == 0);
  }

  boolean addrMatch(byte in[]) {
    int size = addr.length;
    for (int i = 0; i < size; i++) {
      if (in.length-1 < i)
	break;
      if (addr[i] != 0 && addr[i] != in[i])
	return false;
    }
    return true;
  }

  public String toString() {
    String s = "";
    switch (tag) {
    case NAME:
      s = name;
      break;
    case ADDR:
      for (int i = 0; i < addr.length; i++) {
	s = s + ((addr[i])&0xff);
	if (i+1 < addr.length)
	  s = s + ".";
      }
      break;
    }
    return s;
  }
}
