/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.orb;

/**
 * Signals exception of IOCI or protocol error. This exception will be 
 * throwon, if:
 * <NL>
 * <LI> Class major version mismatch between client's proxy and server's skeleton.
 * <LI> IOCI's major version mismatch between client and server.
 * <LI> IOCI class not found at the server side.
 * <LI> Preamble of method call mismatch.
 * </NL>
 */
public class IOCIException extends HORBException {
  public IOCIException(String s) {
    super(s);
  }
  public IOCIException(Exception e) {
    super(e.toString());
  }
}
