/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.orb;

import java.io.*;

/**
 * Information about IOCI.
 */
public class IOCIInfo {

  public short magic = 0x10C1;

  /** File IOCI class name */
  public String IOCIClass;

  /** major version number of IOCI */
  public short IOCI_major_version;

  /** minor version number of IOCI */
  public short IOCI_minor_version;

  public IOCIInfo() {}

  public IOCIInfo(IOCI ioci) {
    IOCIClass = ioci.getClass().getName();
    IOCI_major_version = ioci.getMajorVersion();
    IOCI_minor_version = ioci.getMinorVersion();
  }

  public void list(PrintStream ps) {
    ps.println("magic: "+Integer.toString(magic, 16));
    ps.println("IOCI: "+IOCIClass + " "
	       +IOCI_major_version + "." +IOCI_minor_version);
  }
}
