/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.orb;

import horb.orb.*;
import java.io.*;

/**
 * lock object.
 */
class Lock {
  boolean locked = true;

  synchronized boolean lock(long timeout) {
    try {
      if (locked)
	wait(timeout);
    } catch (InterruptedException e) {}
    if (locked)
      return false;
    locked = true;
    return true;
  }

  synchronized void unlock() throws IllegalMonitorStateException {
    notify();
    locked = false;
  }

  boolean isLocked() {
    return locked;
  }
}
