/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.orb;

import java.util.*;

/**
 * Sender side of the object loop checker. This is Loopy. Peer is Goldberg.
 */
public class Loopy extends Hashtable {
  private int objectNumber = 0;

  /**
   * if the object has already appeared, returns the sequence number of
   * the object. otherwise return 0.
   * @param o object to check and record.
   */
  public final synchronized int check(Object o) {
    Integer i = (Integer)get(o);
    if (i == null) {
      put(o, new Integer(objectNumber++));
//      System.out.println("check: put object "+o+" as "+(objectNumber-1));
      return -1;
    } else {
//      System.out.println("check: found object "+o+" as "+i.intValue());
      return i.intValue();
    }
  }
}
