/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.orb;

/**
 * Signals exception during network operation. This exception will be 
 * throwon, when:
 * <NL>
 * <LI> Failure to establish a network connection
 * <LI> Network disconnect
 * <LI> Network error
 * <LI> File I/O error
 * <LI> Other I/O error
 * </NL>
 */
public class NetException extends HORBException {
  public NetException(String s) {
    super(s);
  }
  public NetException(Exception e) {
    super(e.toString());
  }
}
